# $Id: navigation.rb,v 1.1 2004/01/17 12:02:32 hn Exp $
# Copyright Narushima Hironori. All rights reserved.

require 'rexml/document'
require 'rexml/streamlistener'
require 'net/http'
require 'uri'

module SiteMapper

module_function

def to_rel(base, target)
	sep = /#{File::SEPARATOR}+/o
	base = base.split(sep)
	base.pop
	target = target.split(sep)
	while base.first == target.first
		base.shift
		target.shift
	end
	File.join([".."] * base.size + target)
end

class NavigatorFactory

	HIERARCHY_KEYS = [:start, :chapter, :section, :subsection, :subsubsection]
	MIGRATE_KEYS = [:next, :prev, :up]
	EXT_KEYS = [:self]
	NAVI_KEYS = HIERARCHY_KEYS + MIGRATE_KEYS + EXT_KEYS

	@@instances = Hash.new { |hash, tocpath|
		hash[tocpath] = NavigatorFactory.new(tocpath)
	}

	def NavigatorFactory.instance(tocpath)
		@@instances[File.expand_path(tocpath)]
	end
	
	def NavigatorFactory.clear_cache(tocpath = nil)
		if tocpath
			@@instances.delete(File.expand_path(tocpath))
		else
			@@instances.clear
		end
	end

	def initialize(docpath)
		@docpath = docpath
		open(docpath) { |fh|
			@doc = REXML::Document.new(fh)
		}
	end

	attr_reader :doc

	def create_by_path( path)
		path = path.sub(/^\/+/, '')
		elem = search_element(@doc, path)
		create_navi(elem) if elem
	end

	def search_element(elem, path)
		elem.each_element { |e|
			return e if e.attributes['href'] == path
			e = search_element(e, path)
			return e if e
		}
		nil
	end

	def create_navi(self_elem)
		navi_elems = {
			:self => self_elem,
			:next => choose_next(self_elem),
			:prev => choose_prev(self_elem),
			:up => (self_elem.parent and self_elem.parent.name == 'topic') ? self_elem.parent : nil,
		}
		
		hierarchy = []
		e = self_elem
		begin
			hierarchy << e
		end while (e = e.parent) and (e.name == 'topic')
		HIERARCHY_KEYS.each { |k|
			navi_elems[k] = hierarchy.pop
		}
		
		current_url = self_elem.attributes['href']
		
		result = {}
		navi_elems.each { |key, elem|
			next unless elem
			
			href = elem.attributes['href']
			if href and !(%r!^.+?://! === href)
				href = SiteMapper::to_rel(current_url, href)
			end
			
			result[key] = { :url => href, :title => elem.attributes['label'] }
		}
		result
	end
	
	def choose_next(elem)
		next_elem = nil
		
		if elem.has_elements?
			next_elem = elem.elements[1]
		elsif e = elem.next_element
			next_elem = e
		else
			while elem = elem.parent
				if ne = elem.next_element
					next_elem = ne
					break
				end
			end
		end
		
		if next_elem
			attrs = next_elem.attributes
			if attrs['label'] and !attrs['href']
				return choose_next(next_elem)
			end
		end
		
		next_elem
	end
	
	def choose_prev(elem)
		prev_elem = nil
		
		if prev = elem.previous_element
			begin
				if !prev.has_elements?
					prev_elem = prev
					break
				end
			end while prev = prev.elements.to_a.last
		else
			p = elem.parent
			prev_elem = p if p.name == 'topic'
		end
		
		if prev_elem
			attrs = prev_elem.attributes
			if attrs['label'] and !attrs['href']
				return choose_prev(prev_elem)
			end
		end
		
		prev_elem
	end
	
end

end
