/*
 * $Id: PresetSelectionWizardPage.java,v 1.6 2004/06/07 06:46:21 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.wizards;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.preset.*;
import com.narucy.webpub.ui.WebpubUIPlugin;

public class PresetSelectionWizardPage extends WizardPage {
	
	Preset[] presets = PresetManager.getInstance().getPresets();

	List presetList;
	Text descriptionText;
	
	public PresetSelectionWizardPage() {
		super("PresetSelectionWizardPage");
		setTitle("Preset");
		setDescription("You can select presets that for easy to initialization web files");
		setImageDescriptor(WebpubUIPlugin.getImageDescriptor("wizban/newwebproj_wiz.gif"));
	}

	public void createControl(Composite parent) {
		// create controls
		Composite topComp = new Composite(parent, SWT.NONE);
		topComp.setLayout(new GridLayout(2, false));
		
		new Label(topComp, SWT.NONE).setText("Available presets:");
		new Label(topComp, SWT.NONE);
		
		presetList = new List(topComp, SWT.SINGLE | SWT.READ_ONLY | SWT.BORDER);
		presetList.setLayoutData(new GridData(GridData.FILL_BOTH));
		for (int i=0; i<presets.length; i++) {
			presetList.add(presets[i].getName());
		}
		
		descriptionText = new Text(topComp, SWT.MULTI | SWT.READ_ONLY | SWT.WRAP | SWT.BORDER);
		descriptionText.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		presetList.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				refreshState();
			}
		});
		setSelectionIndex(0);
		setControl(topComp);
		
		// naming control for testing
		presetList.setData("presetList");
		descriptionText.setData("descriptionText");
	}
	
	public void setSelectionIndex(int index){
		if(index < 0){
			presetList.deselectAll();
		}else{
			presetList.setSelection(index);
		}
		refreshState();
	}
	
	void refreshState(){
		Preset preset = getSelectedPreset();
		if(preset != null){
			descriptionText.setText(preset.getDescription());
		}else{
			descriptionText.setText("");
		}
	}
	
	public Preset getSelectedPreset(){
		int index = presetList.getSelectionIndex();
		return (index >= 0) ? presets[index] : null;
	}
	
	public void storePresets(WebProject desc, IProgressMonitor monitor) throws CoreException {
		try{
			monitor.beginTask("apply preset", 2);
			ResourcesPlugin.getWorkspace().run( new PresetStoreProc(desc), new SubProgressMonitor(monitor, 1));
			desc.getProject().refreshLocal(IResource.DEPTH_INFINITE, new SubProgressMonitor(monitor, 1));
		}finally{
			monitor.done();
		}
	}
	
	class PresetStoreProc implements IWorkspaceRunnable{
		
		WebProject webProject;
		
		PresetStoreProc(WebProject webProj){
			this.webProject = webProj;
		}
		
		public void run(IProgressMonitor monitor) throws CoreException {
		}
	}
	
}
