/*
 * $Id: InitialWebPageWizardPage.java,v 1.4 2004/06/07 06:46:22 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.wizards;

import org.eclipse.core.resources.*;
import org.eclipse.jface.dialogs.*;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;

import com.narucy.webpub.ui.WebpubUIPlugin;

public class InitialWebPageWizardPage extends WizardPage {

	final static String
		SETTING_KEY_INITIAL_FILE_HISTORY = "InitialWebPageHistory";

	final static int MAX_HISTORY_COUNT = 10;

	IContainer htSourceFolder;
	Combo historyCombo;
	IFile result = null;
	IInputValidator validator;
	
	IDialogSettings settings;
	
	static IDialogSettings getDialogSetting(){
		IDialogSettings rootSettings = WebpubUIPlugin.getDefault().getDialogSettings();
		IDialogSettings wizpageSettings  = rootSettings.getSection(SETTING_KEY_INITIAL_FILE_HISTORY);
		if( wizpageSettings == null){
			wizpageSettings = rootSettings.addNewSection(SETTING_KEY_INITIAL_FILE_HISTORY);
		}
		return wizpageSettings;
	}
	
	public InitialWebPageWizardPage(IContainer htSourceFolder, IInputValidator validator) {
		super("NewWebPageWizardPage");
		this.htSourceFolder = htSourceFolder;
		this.validator = validator;

		setTitle("Web Page");
		setDescription("Select initial HTML document for new web page.");
		
		settings = getDialogSetting();
	}
	
	public void createControl(Composite parent) {
		Composite base = new Composite(parent, SWT.NONE);
		setControl(base);
		base.setLayout(new GridLayout(2, false));
		
		new Label(base, SWT.NONE).setText("Initial HTML:");
		new Label(base, SWT.NONE);
		
		historyCombo = new Combo(base, SWT.BORDER | SWT.READ_ONLY | SWT.DROP_DOWN);
		historyCombo.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		Button button = new Button(base, SWT.PUSH);
		button.setText("B&rowse...");
		button.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				handleBrowseButtonPressed();
			}
		});
		
		// initial history
		historyCombo.add("");

		String[] history = settings.getArray(htSourceFolder.getProject().getName());
		if( history != null ){
			IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
			for (int i = 0; i < history.length && i < MAX_HISTORY_COUNT; i++) {
				IResource file = root.findMember(history[i]);
				if( file instanceof IFile && validator.isValid(file.getName()) == null){
					String path = file.getFullPath().toString();
					int index = historyCombo.indexOf(path);
					if(index == -1){
						historyCombo.add(path);
					}else{
						// if already added to history list, selection that.
						historyCombo.select(index);
					}
				}
			}
		}
		historyCombo.select(0);
	}
	
	void handleBrowseButtonPressed(){
		ResourceSelectionDialog dialog = new ResourceSelectionDialog(
			InitialWebPageWizardPage.this.getShell(),
			htSourceFolder,
			"Selection initial html file for new web page");
		
		if( dialog.open() == Window.OK){
			Object res = dialog.getResult()[0];
			if( res instanceof IFile){
				IFile result = (IFile)res;
				String filePath = result.getFullPath().toString();

				String errMsg = validator.isValid(filePath);
				if(errMsg != null){
					setErrorMessage(errMsg);
				}else{
					historyCombo.remove(0);
					historyCombo.add(filePath, 0);
					historyCombo.select(0);
				}
			}
		}
	}

	public IFile getResult() {
		String result = historyCombo.getText();
		return result.length() > 0 ?
			(IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(result) :
			null;
	}

	public void putHistory() {
		String[] history = historyCombo.getItems();
		// If user do not selection, no distribute dialog settings.
		if(history[0].length() > 0){
			settings.put(htSourceFolder.getProject().getName(), history);
		}
	}

}
