/*
 * $Id: TocActionGroup.java,v 1.3 2004/06/07 06:46:22 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.views;

import org.eclipse.jface.action.*;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.views.navigator.*;

/**
 * 
 */
class TocActionGroup extends MainActionGroup {

	public TocActionGroup(IResourceNavigator navi) {
		super(navi);
	}

	public void fillActionBars(IActionBars actionBars) {
		actionBars.setGlobalActionHandler(
			ActionFactory.PROPERTIES.getId(),
			propertyDialogAction);
		actionBars.setGlobalActionHandler(
			IDEActionFactory.BOOKMARK.getId(),
			addBookmarkAction);
		actionBars.setGlobalActionHandler(
			IDEActionFactory.ADD_TASK.getId(),
			addTaskAction);
			
		gotoGroup.fillActionBars(actionBars);
		openGroup.fillActionBars(actionBars);
		refactorGroup.fillActionBars(actionBars);
		workingSetGroup.fillActionBars(actionBars);
//		sortAndFilterGroup.fillActionBars(actionBars);
		workspaceGroup.fillActionBars(actionBars);
		
		IMenuManager menu = actionBars.getMenuManager();
		menu.add(toggleLinkingAction);
		
		IToolBarManager toolBar = actionBars.getToolBarManager();
		toolBar.add(new Separator());
		toolBar.add(collapseAllAction);		
		toolBar.add(toggleLinkingAction);
	}

}
