/*
 * $Id: HTPreviewSelectionProvider.java,v 1.6 2004/06/07 06:46:22 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.views;

import java.io.File;
import java.net.*;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.*;

/**
 * 
 */
class HTPreviewSelectionProvider implements IInputSelectionProvider {
	
	final HTPreView preview;
	ListenerList listenerList = new ListenerList();
	ISelection selection = new StructuredSelection();

	public HTPreviewSelectionProvider(HTPreView preview) {
		this.preview = preview;
	}

	public void addSelectionChangedListener(ISelectionChangedListener listener) {
		listenerList.add(listener);
	}

	public ISelection getSelection() {
		return selection;
	}

	public void removeSelectionChangedListener(ISelectionChangedListener listener) {
		listenerList.remove(listener);
	}

	public void setSelection(ISelection sel) {
		if(sel instanceof IStructuredSelection){
			try{
				URL url = new URL( ((IStructuredSelection)sel).getFirstElement().toString() );
				File f = new File(url.getFile());
				if(f.exists()){
					IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(new Path(f.toString()));
					if(files.length > 0){
						sel = new StructuredSelection(files);
					}
				}
			}catch(MalformedURLException e){
			}
		}
		if(!sel.equals(selection)){
			selection = sel;
			Object[] ls = listenerList.getListeners();
			for(int i=0; i<ls.length; i++){
				((ISelectionChangedListener)ls[i]).selectionChanged(new SelectionChangedEvent(this, sel));
			}
		}
	}

	public Object getInput() {
		return selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).getFirstElement() : null;
	}

}
