/*
 * $Id: PublishMappingDocumentProxy.java,v 1.3 2004/06/07 06:46:16 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.properties;

import org.w3c.dom.*;

class PublishMappingDocumentProxy {

	Document doc;
	
	PublishMappingDocumentProxy(Document doc){
		this.doc = doc;
	}
	
	int getDescriptionCount(){
		return getPublishElements().length;
	}
	
	int nodeIndex(Element e){
		Element[] elems = getPublishElements();
		for(int i=0; i<elems.length; i++){
			if(elems[i].equals(e)){
				return i;
			}
		}
		return -1;
	}

	Element[] getPublishElements(){
		Element rootElem = doc.getDocumentElement();
		NodeList nodes = rootElem.getElementsByTagName("mapping");
		
		int len = nodes.getLength();
		Element[] elems = new Element[len];
		for(int i=0; i<len; i++){
			elems[i] = (Element)nodes.item(i);
		}
		return elems;
	}
	
	void moveElement(Element moveTargetElem, int moveCount){
		int index = nodeIndex(moveTargetElem);
		Element rootElem = doc.getDocumentElement();
		Element[] pubElems = getPublishElements();
		
		boolean upCmd = 0 > moveCount;
		for(int i=0, j=upCmd ? index : index+1; i<Math.abs(moveCount); i++){
			if(upCmd){
				// up
				rootElem.insertBefore(moveTargetElem, pubElems[--j] );
			}else{
				// down
				if(++j<pubElems.length){
					rootElem.insertBefore( moveTargetElem, pubElems[j] );
				}else{
					rootElem.appendChild(moveTargetElem);
				}
			}
		}
	}
	
	void removeElement(Element elem){
		Element rootElem = doc.getDocumentElement();
		rootElem.removeChild(elem);
	}
	
	void addInitialPublishDescription(){
		addInitialPublishDescription(null);
	}

	void addInitialPublishDescription(Element insertBeforeElem){
		Element rootElem = doc.getDocumentElement();
		
		Element newMappingElem = doc.createElement("mapping");
		newMappingElem.setAttribute("pattern", "**/*");
		if( insertBeforeElem != null){
			rootElem.insertBefore(newMappingElem, insertBeforeElem);
		}else{
			rootElem.appendChild(newMappingElem);
		}
	
		Element newPublishElem = doc.createElement("publish");
		newMappingElem.appendChild(newPublishElem);
		newPublishElem.setAttribute("by", "copy");
	}
	
	Document getDocument(){
		return doc;
	}
}