package com.narucy.webpub.ui.preferences;

import org.eclipse.jface.preference.*;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.*;

import com.narucy.webpub.ui.WebpubUIPlugin;

/**
 * @see PreferencePage
 */
public class PublishPreferencePage extends FieldEditorPreferencePage implements IWorkbenchPreferencePage {
	
	public PublishPreferencePage(){
		super(GRID);
		setPreferenceStore(WebpubUIPlugin.getDefault().getPreferenceStore());
	}

	protected void createFieldEditors() {
		Composite parent = getFieldEditorParent();
		addField(new BooleanFieldEditor(
				WebpubUIPlugin.PUBLISH_BACKGROUND,
				"Publish command process in background",
				parent));
		
		addField(new BooleanFieldEditor(
				WebpubUIPlugin.HOCK_PUBLISH_ACTION_WITH_PREVIEW,
				"Hock publish action (in Project menu) target resource as HTML Preview",
				parent));
	}

	public void init(IWorkbench workbench) {
	}
	
}
