/*
 * $Id: TocMultiPageEditor.java,v 1.6 2004/06/07 06:46:21 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.editors.toc;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.*;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.toc.*;
import com.narucy.webpub.ui.WebpubUIPlugin;

/**
 * 
 */
public class TocMultiPageEditor extends MultiPageEditorPart {
	
	TopicPropertySheetPage propPage;
	
	Toc toc = null;
	
	TocTextEditor textEditor;
	TocTreeEditor treeEditor;
	
	public TocMultiPageEditor() {
	}

	public void init(IEditorSite site, IEditorInput input) throws PartInitException {
		if(!(input instanceof IFileEditorInput)){
			throw new PartInitException("Input must be file input:" + input);
		}
		IFile f = ((IFileEditorInput)input).getFile();
		if(!f.isAccessible()){
			throw new PartInitException("File must be accessible:" + f.getFullPath());
		}
		try {
			toc = TocFactory.createToc(f);
		} catch (CoreException e) {
			throw new PartInitException(e.getStatus());
		}
		if(toc == null){
			toc = new Toc(null, f.getFullPath().toString());
		}
		
		super.init(site, input);
	}

	protected void createPages() {
		// ui based tree editor.
		try {
			treeEditor = new TocTreeEditor(this);
			addPage( treeEditor, getEditorInput());
		} catch (PartInitException e) {
			addPage(createErrorLabel(e));
		}
		setPageText(0, "Sitemap Tree");
		
		// text editor
		try{
			textEditor = new TocTextEditor(this);
			addPage(textEditor, getEditorInput());
		}catch(PartInitException e){
			addPage(createErrorLabel(e));
		}
		setPageText(1, "Source");
		
		setPartName(getEditorInput().getName());
	}
	
	Label createErrorLabel(PartInitException e){
		Label labe = new Label(getContainer(), SWT.NONE);
		labe.setText(e.getMessage());
		return labe;
	}

	public void doSave(IProgressMonitor monitor) {
		getEditor(1).doSave(monitor);
		IFile f = ((IFileEditorInput)getEditorInput()).getFile();
		try {
			WebProject wp = (WebProject)f.getProject().getNature(WebProject.ID_NATURE);
			if(wp != null){
				Toc projectToc = wp.getToc(f);
				if(projectToc != null){
					projectToc.applyToc(toc);
					projectToc.fireChanged();
				}
			}
		}catch(CoreException e){
			WebpubUIPlugin.handleException(e);
		}
	}

	public void doSaveAs() {
		IEditorPart editor = getEditor(1);
		editor.doSaveAs();
		
		setInput(editor.getEditorInput());
		setPartName(editor.getEditorInput().getName());
	}

	public boolean isDirty() {
		return getPageCount() > 1 ? getEditor(1).isDirty() : false;
	}

	public void gotoMarker(IMarker marker) {
		setActivePage(1);
		IEditorPart editor = getEditor(1);
		IGotoMarker gotoMarker = (IGotoMarker)((editor instanceof IGotoMarker) ? editor : editor.getAdapter(IGotoMarker.class));
		if(gotoMarker != null){
			gotoMarker.gotoMarker(marker);
		}
	}

	public Object getAdapter(Class key) {
		if (key.equals(IPropertySheetPage.class)) {
			if(propPage == null){
				propPage = new TopicPropertySheetPage();
			}
			return propPage;
		}
		return super.getAdapter(key);
	}

	public boolean isSaveAsAllowed() {
		return true;
	}
	
	public Toc getToc() {
		return toc;
	}

}

