/*
 * $Id: TemplateContentSelectionWizardPage.java,v 1.6 2004/06/07 06:46:20 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.editors.html.wizards;

import java.io.IOException;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.template.*;

/**
 * 
 */
class TemplateContentSelectionWizardPage extends WizardPage implements IPreviewer {

	TemplateParser tmplParser = new TemplateParser();
	
	Text preview;
	Combo filesCombo;
	Combo definedLineCombo;

	String tmplName = null;
	IFile[] files = null;
	Template[] candidacies = null;
	
	public TemplateContentSelectionWizardPage() {
		super("TemplateContentSelectionWizardPage");
		setTitle("Template Content Selection");
		setDescription("Template content is subtlety different in CONTENT marks, specify your want to insert template text.");
	}
	
	public void setTemplateName(String tmplName){
		this.tmplName = tmplName;
		refreshDefinedFiles();
	}

	public void createControl(Composite parent) {
		Composite base = new Composite( parent, SWT.NONE);
		setControl(base);
		base.setLayout(new GridLayout(2, false));

		new Label(base, SWT.NONE).setText("&Use as content:");

		filesCombo = new Combo(base, SWT.BORDER | SWT.READ_ONLY);
		filesCombo.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		filesCombo.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				updateFile();
			}
			public void widgetDefaultSelected(SelectionEvent e) {}
		});
		
		new Label(base, SWT.NONE).setText("&Preview:");
		definedLineCombo = new Combo(base, SWT.BORDER | SWT.READ_ONLY);
		GridData gd = new GridData( GridData.HORIZONTAL_ALIGN_END);
		gd.widthHint = 100;
		definedLineCombo.setLayoutData(gd);
		definedLineCombo.setEnabled(false);
		definedLineCombo.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				updateDefinedLine();
			}

			public void widgetDefaultSelected(SelectionEvent e) {}
		});
		preview = InsertTemplateWizard.createPreviewText(base);
		
		refreshDefinedFiles();
		filesCombo.forceFocus();
	}
	
	void refreshDefinedFiles(){
		if(filesCombo != null && tmplName != null){
			filesCombo.removeAll();
			TemplateManager tmplMgr = ((InsertTemplateWizard)getWizard()).getTemplateManager();
			files = tmplMgr.getTemplateDefinedFiles(tmplName);
			for (int i = 0; i < files.length; i++) {
				filesCombo.add( files[i].getFullPath().toString() );
			}
			filesCombo.select(0);
			updateFile();
		}
	}

	void updateFile(){
		IFile file = files[ filesCombo.getSelectionIndex() ];
		try {
			WebProject webProj = (WebProject)file.getProject().getNature(WebProject.ID_NATURE);
			
			Template tmpl = tmplParser.parse(file.getContents(), webProj.getString(WebProject.ENCODING));
			setErrorMessage(null);
			
			candidacies = tmpl.getAllTemplates(tmplName);
			definedLineCombo.removeAll();
			definedLineCombo.setEnabled(candidacies.length > 1);
			for(int i=0; i<candidacies.length; i++){
				definedLineCombo.add(candidacies[i].getProperty(TemplateParser.PROP_OFFSET_LINE).toString());
			}
			definedLineCombo.select(0);
			updateDefinedLine();
		} catch (TemplateParseException e) {
			setErrorMessage("Can not parse a specified file.");
		} catch (IOException e) {
			setErrorMessage("Can not read a file.");
		} catch (CoreException e) {
			setErrorMessage("Can not read a file.");
		}
	}
	
	void updateDefinedLine(){
		preview.setText( candidacies[definedLineCombo.getSelectionIndex()].getJoinedLines() );
	}
	
	public String getPreviewText(){
		return (preview != null) ? preview.getText().replaceAll("\r", "") : null;
	}

}
