/*
 * $Id: HTViewerConfiguration.java,v 1.4 2004/06/07 06:46:17 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.editors.html;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.*;
import org.eclipse.jface.text.contentassist.*;
import org.eclipse.jface.text.presentation.*;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.source.*;
import org.eclipse.jface.util.*;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Shell;

import com.narucy.webpub.ui.WebpubUIPlugin;
import com.narucy.webpub.ui.editors.ColorManager;

/**
 * SourceViewer configurator for html editor.
 * 
 */
public class HTViewerConfiguration extends SourceViewerConfiguration implements IPropertyChangeListener {

	ColorManager colorManager;

	HTDoubleClickStrategy doubleClickStrategy = null;
	HTContentAssistProcessor processor = null;
	
	HTScanner htScanner;
	TagScanner tagScanner;
	
	DefaultDamagerRepairer htDr, tagDr;
	NonRuleBasedDamagerRepairer commentDamagerRepairer, erbDamagerRepairer;
	
	IAnnotationHover hover = new IAnnotationHover() {
		public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
			return null;
		}
	};

	public HTViewerConfiguration(ColorManager colorManager) {
		this.colorManager = colorManager;
	}

	public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
		return new String[]{
			IDocument.DEFAULT_CONTENT_TYPE,
			HTPartitionScanner.HTML_TAG,
			HTPartitionScanner.HTML_COMMENT,
			HTPartitionScanner.HTML_ERB,
		};
	}
	
	public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
		return doubleClickStrategy;
	}
	
	public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
		if(htScanner == null){
			htScanner = new HTScanner(colorManager);
			tagScanner = new TagScanner(colorManager);
			
			htDr = new DefaultDamagerRepairer(htScanner);
			tagDr = new DefaultDamagerRepairer(tagScanner);
			
			commentDamagerRepairer = createNonRuleBasedDamagerRepairer(WebpubUIPlugin.HTEDITOR_COLOR_COMMENT);
			erbDamagerRepairer = createNonRuleBasedDamagerRepairer(WebpubUIPlugin.HTEDITOR_COLOR_ERB);
		}

		PresentationReconciler reconciler = new PresentationReconciler();

		reconciler.setDamager(htDr, IDocument.DEFAULT_CONTENT_TYPE);
		reconciler.setRepairer(htDr, IDocument.DEFAULT_CONTENT_TYPE);

		reconciler.setDamager(tagDr, HTPartitionScanner.HTML_TAG);
		reconciler.setRepairer(tagDr, HTPartitionScanner.HTML_TAG);
		
		reconciler.setDamager(commentDamagerRepairer, HTPartitionScanner.HTML_COMMENT);
		reconciler.setRepairer(commentDamagerRepairer, HTPartitionScanner.HTML_COMMENT);
		
		reconciler.setDamager(erbDamagerRepairer, HTPartitionScanner.HTML_ERB);
		reconciler.setRepairer(erbDamagerRepairer, HTPartitionScanner.HTML_ERB);

		return reconciler;
	}
	
	NonRuleBasedDamagerRepairer createNonRuleBasedDamagerRepairer(String key){
		NonRuleBasedDamagerRepairer dr = new NonRuleBasedDamagerRepairer();
		dr.setTextAttribute(new TextAttribute(colorManager.getColor(key)));
		return dr;
	}

	public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
		return hover;
	}

	protected IPreferenceStore getPreferenceStore() {
		return WebpubUIPlugin.getDefault().getPreferenceStore();
	}
	
	ContentAssistant assistant = null;

	public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
		if( assistant == null){
			IPreferenceStore store = getPreferenceStore();
			
			assistant = new ContentAssistant();		
			setCodeAssistEnabled( store.getBoolean(WebpubUIPlugin.HTEDITOR_CONTENT_ASSIST) );
			
			assistant.setInformationControlCreator(new IInformationControlCreator() {
				public IInformationControl createInformationControl(Shell parent) {
					return new DefaultInformationControl(parent, SWT.V_SCROLL | SWT.H_SCROLL, null);
				}
			});
			assistant.enableAutoActivation(true);
			assistant.setAutoActivationDelay( store.getInt(WebpubUIPlugin.HTEDITOR_CONTENT_ASSIST_DELAY));
		}
		return assistant;
	}
	
	public void propertyChange(PropertyChangeEvent event) {
		IPreferenceStore store = WebpubUIPlugin.getDefault().getPreferenceStore();
		
		String prop = event.getProperty();
		if( assistant != null){
			if( prop.equals(WebpubUIPlugin.HTEDITOR_CONTENT_ASSIST) ){
				setCodeAssistEnabled(store.getBoolean(prop));
			}else if(prop.equals(WebpubUIPlugin.HTEDITOR_CONTENT_ASSIST_DELAY)){
				assistant.setAutoActivationDelay(store.getInt(prop));
			}
		}
		if(prop.equals(WebpubUIPlugin.HTEDITOR_COLOR_COMMENT)){
			commentDamagerRepairer.setTextAttribute( new TextAttribute(colorManager.getColor(prop)));
		}else if(prop.equals(WebpubUIPlugin.HTEDITOR_COLOR_ERB)){
			erbDamagerRepairer.setTextAttribute( new TextAttribute(colorManager.getColor(prop) ));
		}else {
			htScanner.propertyChange(event);
			tagScanner.propertyChange(event);
		}
	}
	
	synchronized void setCodeAssistEnabled(boolean enable){
		if(enable == (processor != null)){
			return;
		}
		processor = enable ?
			new HTContentAssistProcessor(colorManager) :
			null;

		assistant.setContentAssistProcessor(processor, IDocument.DEFAULT_CONTENT_TYPE);
		assistant.setContentAssistProcessor(null, HTPartitionScanner.HTML_COMMENT);
		assistant.setContentAssistProcessor(null, HTPartitionScanner.HTML_ERB);
		assistant.setContentAssistProcessor(processor, HTPartitionScanner.HTML_DEFAULT);
		assistant.setContentAssistProcessor(processor, HTPartitionScanner.HTML_TAG);
	}


}