/*
 * $Id: HTOutlinePage.java,v 1.5 2004/06/07 06:46:17 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.editors.html;

import org.eclipse.jface.text.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

import com.narucy.webpub.core.template.*;
import com.narucy.webpub.ui.WebpubUIPlugin;

/**
 * HTOutlinePage
 */
public class HTOutlinePage extends ContentOutlinePage {

	HTEditor htEditor;
	IDocument document;
	HTOutlineContentProvider contentProvider;
	
	public HTOutlinePage(HTEditor editor) {
		htEditor = editor;
	}

	public void createControl(Composite parent) {
		super.createControl(parent);
		
		document = htEditor.getDocumentProvider().getDocument(htEditor.getEditorInput());
		
		TreeViewer viewer= getTreeViewer();
		viewer.setLabelProvider(new HTLabelProvider());
		
		contentProvider = new HTOutlineContentProvider();
		viewer.setContentProvider(contentProvider);
		viewer.setInput(document);
		viewer.addDoubleClickListener(new IDoubleClickListener() {
			public void doubleClick(DoubleClickEvent event) {
				Object elem = ((IStructuredSelection)event.getSelection()).getFirstElement();
				if(elem instanceof Template){
					jumpAsTemplateDefiniedLine((Template)elem);
				}
			}
		});
		viewer.expandAll();
	}

	protected void handleCursorLineChanged(int cursorLineNumber) {
		Template selectionTemplate = contentProvider.getTemporaryTemplate();
		if(selectionTemplate == null){
			return;
		}
		Template[] tmpls = selectionTemplate.getAllTemplates();
		int near = Integer.MAX_VALUE;
		for (int i = 0; i < tmpls.length; i++) {
			Template tmpl = tmpls[i];
			Integer lineNumber = (Integer)tmpl.getProperty(TemplateParser.PROP_OFFSET_LINE);
			if(lineNumber != null){
				int lineNum = lineNumber.intValue();
				int diffLineCount = cursorLineNumber - lineNum;
				if(diffLineCount >= 0 && diffLineCount < near){
					int lineLength = tmpl.getProperty(HTOutlineContentProvider.PROP_LENGTH_LINE) != null ? ((Integer)tmpl.getProperty(HTOutlineContentProvider.PROP_LENGTH_LINE)).intValue() : tmpl.getLines().length;
					if(lineNum + lineLength > cursorLineNumber){
						selectionTemplate = tmpl;
						if(diffLineCount == 0){
							break;
						}
					}
				}
			}
		}
		getTreeViewer().setSelection(new StructuredSelection(selectionTemplate));
	}
	
	
	void jumpAsTemplateDefiniedLine(Template tmpl){
		Integer lineNumber =
			(Integer)tmpl.getProperty( TemplateParser.PROP_OFFSET_LINE);
		
		if( lineNumber != null ){
			int lineNum = lineNumber.intValue();
			try {
				TextSelection textSelection = new TextSelection(
						document.getLineOffset(lineNum),
						document.getLineLength(lineNum));
				htEditor.getSelectionProvider().setSelection(textSelection);
			} catch (BadLocationException e) {
				WebpubUIPlugin.handleException(e);
			}
		}
	}
	

}

