/*
 * $Id: HTDocumentProvider.java,v 1.1 2004/04/11 08:23:40 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.editors.html;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.DefaultPartitioner;
import org.eclipse.ui.editors.text.FileDocumentProvider;

/**
 * <p>
 * HTDocumentProvider provides to create listener for document divide listener
 * for Parser.
 * 
 */
public class HTDocumentProvider extends FileDocumentProvider {

	public HTDocumentProvider() {
		super();
	}

	protected IDocument createDocument(Object element) throws CoreException {
		IDocument document = super.createDocument(element);
		if (document != null) {
			DefaultPartitioner partitioner =
				new DefaultPartitioner(
					new HTPartitionScanner(),
					new String[] {
						HTPartitionScanner.HTML_TAG,
						HTPartitionScanner.HTML_COMMENT,
						HTPartitionScanner.HTML_ERB });
			
			partitioner.connect(document);
			document.setDocumentPartitioner(partitioner);
		}
		return document;
	}
	
}