/*
 * $Id: EscapeTagAction.java,v 1.3 2004/06/07 06:46:21 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.actions;

import org.eclipse.jface.text.*;

import com.narucy.webpub.core.HTMLUtilities;

public class EscapeTagAction extends UnescapeTagAction {

	public EscapeTagAction(){
		super(new String[]{"<", ">", "&", "\""});
	}

	protected void doReplace(IDocument doc, ITextSelection sel) throws BadLocationException {
		doc.replace(
			sel.getOffset(),
			sel.getLength(),
			HTMLUtilities.escape(sel.getText()));
	}

}
