/*
 * $Id: WebpubUIPlugin.java,v 1.15 2004/06/10 21:15:09 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.*;

import org.eclipse.core.runtime.*;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.*;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.*;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;

import com.narucy.webpub.core.WebpubPlugin;

/**
 * The main plugin class.
 */
public class WebpubUIPlugin extends AbstractUIPlugin {

	final public static String
		// name
		ID_PLUGIN = "com.narucy.webpub",
		// preference keys
		HTPREVIEW_EXTENSIONS = "htpreview_extensions",
		HTEDITOR_DISPLAYED_TAB_WIDTH = "hteditor_displayed_tab_editor",
		HTEDITOR_WORDWRAP = "hteditor_wordwrap",
		HTEDITOR_COLOR_BACKGROUND = "hteditor_color_background",
		HTEDITOR_COLOR_DEFAULT = "hteditor_color_default",
		HTEDITOR_COLOR_TAG = "hteditor_color_tag",
		HTEDITOR_COLOR_ATTR = "hteditor_color_attr",
		HTEDITOR_COLOR_COMMENT = "hteditor_color_comment",
		HTEDITOR_COLOR_ERB = "hteditor_color_erb",
		HTEDITOR_COLOR_PROCESSOR = "hteditor_color_processor",
		HTEDITOR_CONTENT_ASSIST = "hteditor_content_assist",
		HTEDITOR_CONTENT_ASSIST_DELAY = "hteditor_content_assist_delay",
		PUBLISH_BACKGROUND = "publish_background",
		HOCK_PUBLISH_ACTION_WITH_PREVIEW = "hock_publish_action_with_preview",
		RUBY_INTERPRETER_LOCATION = "ruby_interpreter_location";

	static WebpubUIPlugin plugin;
	static ResourceBundle resourceBundle;

	public WebpubUIPlugin() {
		plugin = this;
		try {
			resourceBundle= ResourceBundle.getBundle("webpubui");
		} catch (MissingResourceException x) {
			resourceBundle = null;
		}
	}
	
	public static ResourceBundle getResourceBundle(){
		return resourceBundle;
	}

	public static WebpubUIPlugin getDefault() {
		return plugin;
	}
	
	public static void handleException(Exception e){
		plugin.getLog().log(
				(e instanceof CoreException) ?
					((CoreException)e).getStatus() :
					new Status(IStatus.ERROR, ID_PLUGIN, IStatus.OK, e.getMessage() == null ? "error" : e.getMessage(), e) );
	}

	/**
	 * Initializes a preference store with default preference values 
	 * for this plug-in.
	 */
	protected void initializeDefaultPreferences(IPreferenceStore store) {
		
		// initialize preview preference
		IPath rubyPath = WebpubPlugin.findInitialInterpreter();
		store.setDefault(
			RUBY_INTERPRETER_LOCATION, rubyPath != null ?
				rubyPath.toString() :
				"c:/ruby/bin/ruby.exe");
		store.setDefault( HTPREVIEW_EXTENSIONS,
			"html htm erb xml jpeg jpg gif png rd");

		store.setDefault(PUBLISH_BACKGROUND, true);
		store.setDefault(HOCK_PUBLISH_ACTION_WITH_PREVIEW, true);
		
		// initialize html editor preference
		store.setDefault(HTEDITOR_DISPLAYED_TAB_WIDTH, 4);
		store.setDefault(HTEDITOR_WORDWRAP, false);
		store.setDefault(HTEDITOR_COLOR_BACKGROUND, "255,255,255");
		store.setDefault(HTEDITOR_COLOR_DEFAULT, "0,0,0");
		store.setDefault(HTEDITOR_COLOR_TAG, "0,0,127");
		store.setDefault(HTEDITOR_COLOR_COMMENT, "0,127,0");
		store.setDefault(HTEDITOR_COLOR_ERB, "127,127,127");
		store.setDefault(HTEDITOR_COLOR_ATTR, "127,0,0");
		store.setDefault(HTEDITOR_COLOR_PROCESSOR, "127,0,127");

		store.setDefault(HTEDITOR_CONTENT_ASSIST, true);
		store.setDefault(HTEDITOR_CONTENT_ASSIST_DELAY, 500);
		store.addPropertyChangeListener(new IPropertyChangeListener() {
			public void propertyChange(PropertyChangeEvent event) {
				if(event.getProperty().equals(RUBY_INTERPRETER_LOCATION)){
					refreshInterpreterLocation();
				}
			}
		});
		refreshInterpreterLocation();
	}

	void refreshInterpreterLocation(){
		IPreferenceStore store = getPreferenceStore();
		String location = store.getString(RUBY_INTERPRETER_LOCATION);
		if( location != null && location.length() > 0){
			WebpubPlugin.getDefault().setRubyCommandPath(new Path(location));
		}
	}
	
	public static String join(String[] vals){
		StringBuffer buff = new StringBuffer();
		for (int i = 0; i < vals.length; i++) {
			buff.append(vals[i]);
			if(i != vals.length-1){
				buff.append(' ');
			}
		}
		return buff.toString();
	}
	
	public static ImageDescriptor getImageDescriptor(String iconPath){
		URL imgUrl = plugin.find(new Path("icons/" + iconPath));
		if(imgUrl == null){
			throw new IllegalArgumentException(iconPath);
		}
		return ImageDescriptor.createFromURL(imgUrl);
	}
	
	public static Image createImage(String iconPath){
		return getImageDescriptor(iconPath).createImage();
	}
	
	public static IWorkbenchWindow getActiveWorkbenchWindow(){
		return plugin.getWorkbench().getActiveWorkbenchWindow();
	}
	
	public static IWorkbenchPage getActivePage(){
		return getActiveWorkbenchWindow().getActivePage();
	}

	public static String getRDTSelectedInterpreterLocation(){
		try{
			Bundle bundle = Platform.getBundle("org.rubypeople.rdt.launching");
			Class klass = bundle.getClass().getClassLoader().loadClass("org.rubypeople.rdt.internal.launching.RubyRuntime");
			Method method = klass.getDeclaredMethod("getDefault", new Class[0]);
			Object rubyRuntime = method.invoke(klass, new Object[0]);
			Method getSelectedInterpreterMethod = rubyRuntime.getClass().getDeclaredMethod("getSelectedInterpreter", new Class[0]);
			Object rubyInterpreter = getSelectedInterpreterMethod.invoke(rubyRuntime, new Object[0]);
			Method getLocationMethod = rubyInterpreter.getClass().getDeclaredMethod("getCommand", new Class[0]);
			return (String)getLocationMethod.invoke(rubyInterpreter, new Object[0]);
		}catch(Exception e){
		}
		return null;
	}

}
