/*
 * $Id: ErrorDecorator.java,v 1.9 2004/06/07 06:46:18 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui;

import java.util.ArrayList;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;
import org.eclipse.jface.viewers.*;

import com.narucy.webpub.core.publish.PublisherBuilder;

/**
 * ErrorDecorator provides to display missing mark.
 */
public class ErrorDecorator extends LabelProvider implements ILightweightLabelDecorator, IResourceChangeListener {

	public ErrorDecorator(){
		ResourcesPlugin.getWorkspace().addResourceChangeListener(this);
	}
	
	public void resourceChanged(IResourceChangeEvent event) {
		try{
			if(event.getDelta() == null){
				return;
			}
			final ArrayList refreshResources = new ArrayList();
			
			event.getDelta().accept(new IResourceDeltaVisitor() {
				public boolean visit(IResourceDelta resourceDelta) throws CoreException {
					if((resourceDelta.getFlags() & IResourceDelta.MARKERS) != 0){
						IMarkerDelta[] markerDeltas = resourceDelta.getMarkerDeltas();
						for (int i = 0; i < markerDeltas.length; i++) {
							IMarkerDelta markerDelta = markerDeltas[i];
							if(markerDelta.isSubtypeOf(PublisherBuilder.MARKER_PUBLISH) ){
								int kind = markerDelta.getKind();
								IMarker marker = markerDelta.getMarker();
								if(kind == IResourceDelta.ADDED){
									refreshResources.add(marker.getResource());
								}else if(kind == IResourceDelta.REMOVED){
									refreshResources.add(marker.getResource());
								}
							}
						}
					}
					return true;
				}
			});
			if(!refreshResources.isEmpty()){
				// notify to parent folders;
				for(int i=0, len = refreshResources.size(); i<len; i++){
					for(IContainer c = ((IResource)refreshResources.get(i)).getParent(); !(c instanceof IWorkspaceRoot); c = c.getParent()){
						if(refreshResources.contains(c)){
							break;
						}
						refreshResources.add(c);
					}
				}
				fireLabelProviderChanged(new LabelProviderChangedEvent(
						this,
						refreshResources.toArray()));
			}
		}catch(CoreException e){
			WebpubUIPlugin.handleException(e);
		}
	}

	public void decorate(Object element, IDecoration decoration) {
		if(!(element instanceof IAdaptable)){
			return;
		}
		IResource res = element instanceof IResource ?
			(IResource)element :
			(IResource)((IAdaptable)element).getAdapter(IResource.class);
		
		try {
			IMarker[] markers = res.findMarkers(IMarker.PROBLEM, true, IResource.DEPTH_INFINITE);
			for (int i = 0; i < markers.length; i++) {
				String type = markers[i].getType();
				if( type.equals(PublisherBuilder.MARKER_RUBY) ){
					decoration.addOverlay(WebpubUIPlugin.getImageDescriptor("ovr16/error_ovr.gif"));
				} else if( type.equals(PublisherBuilder.MARKER_MISSED_SRC)){
					decoration.addOverlay( WebpubUIPlugin.getImageDescriptor("ovr16/missedsrc_ovr.gif"));
				}
			}
		} catch (CoreException e) {
			WebpubUIPlugin.handleException(e);
		}
	}

	public void dispose() {
		ResourcesPlugin.getWorkspace().removeResourceChangeListener(this);
	}
}
