/*
 * $Id: HTPreViewTest.java,v 1.13 2004/06/07 06:46:43 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.tests.views;

import java.util.Arrays;

import junit.framework.TestCase;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.FileEditorInput;

import com.narucy.webpub.core.*;
import com.narucy.webpub.core.tests.WebpubTestPlugin;
import com.narucy.webpub.ui.WebpubUIPlugin;
import com.narucy.webpub.ui.tests.UITestUtils;
import com.narucy.webpub.ui.views.*;

/**
 * <ul>
 * <li>If preview reosurce is removed and auto actived button checked,
 * next candidacy preview item, in last item, to no availabled preview page.
 * 
 * <li>Open editor and that edit file is previewble (that judge is refer the file
 * extension that case of html or htm or rd or gif and more in default.)
 * Addition to browse target list htat file. In this test, open html and gif.
 * 
 * <li>If auto actived checked, editor target changed when browse preview
 * and browse target check button state changed.
 * 
 * <li>Input url form text composite when changed browse web page, and added history
 * list. that repeat 10 count, history list is shift last url form history list.
 * 
 * </ul>
 */
public class HTPreViewTest extends TestCase {
	
	IWorkbenchPage page;
	HTPreView view;

	public HTPreViewTest(String arg0) {
		super(arg0);
	}

	protected void setUp() throws Exception {
		page = WebpubUIPlugin.getActivePage();
		view = (HTPreView)page.showView("com.narucy.webpub.ui.views.HTPreView");
	}
	
	void openEditor(IFile f) throws Exception {
		page.openEditor(new FileEditorInput(f), "org.eclipse.ui.DefaultTextEditor");
		UITestUtils.whileReadAndDispatch();
	}

	void waitForLoad() throws Exception{
		while(view.isLoading()){
			UITestUtils.whileReadAndDispatch();
		}
	}
	
	public void testUrlHistory() throws Exception {
		for(int i=1; i<=15; i++){
			view.enterUrl("http://www.foo.com/" + i + ".html");
		}
		UITestUtils.whileReadAndDispatch();
		
		String[] history = view.getHistory();
		assertEquals(10, history.length);
		
		assertEquals("http://www.foo.com/15.html", history[0]);
		assertEquals("http://www.foo.com/6.html", history[9]);
	}

	public void testBrowseActionState() throws Exception {
		WebProject wp = WebpubTestPlugin.createTestProject("test_projects/TemplateTest-UTF-8");
		IProject proj = wp.getProject();
		try {
			org.eclipse.core.runtime.Preferences pref = ResourcesPlugin.getPlugin().getPluginPreferences();
			pref.setValue(ResourcesPlugin.PREF_ENCODING, wp.getString(WebProject.ENCODING));
			
			view.getLinkWithEditorManager().getLinkWithEditorAction().setChecked(true);
			IFile af = proj.getFile("ht_sources/a.html");
			IFile bf = proj.getFile("ht_sources/b.htm");
			IFile cf = proj.getFile("ht_sources/c.erb");
			IFile xf = proj.getFile("ht_sources/x.xhtml");
			
			openEditor(af);
			openEditor(bf);
			openEditor(cf);
			openEditor(xf);
			
			assertTrue( view.isPreviewble(af) );
			assertTrue( view.isPreviewble(bf) );
			assertTrue( view.isPreviewble(cf) );
			assertFalse( view.isPreviewble(xf) );
			
			assertRegistedFiles(new IFile[]{af, bf, cf});
			
			// run action test
			HTPreviewLinkWithEditorManager mgr = view.getLinkWithEditorManager();
			mgr.getBrowseAction(bf).run();
			waitForLoad();
			assertEquals(view.getCurrentPublishFrom(), bf);
			assertTrue(!mgr.getBrowseAction(af).isChecked());
			assertTrue(mgr.getBrowseAction(bf).isChecked());
			assertTrue(!mgr.getBrowseAction(cf).isChecked());
			
			// specify null
			view.browse(null);
			assertEquals(3, mgr.getRegistedFiles().length);
			assertTrue(!mgr.getBrowseAction(af).isChecked());
			assertTrue(!mgr.getBrowseAction(bf).isChecked());
			assertTrue(!mgr.getBrowseAction(cf).isChecked());

			// run action test
			mgr.getBrowseAction(af).run();
			waitForLoad();
			assertEquals(view.getCurrentPublishFrom(), af);
			assertTrue(mgr.getBrowseAction(af).isChecked());
			assertTrue(!mgr.getBrowseAction(bf).isChecked());
			assertTrue(!mgr.getBrowseAction(cf).isChecked());
			
			// direct input url
			IPath pubTo =  wp.getPublishDescriptionFactory().create(bf).getPublishTo();
			IFile pubToResource = wp.getFolder(WebProject.PUBLISH_FOLDER).getFile(pubTo);
			view.browse(pubToResource.getLocation().toFile().toURL().toString());
			waitForLoad();
			assertRegistedFiles(new IFile[]{af, bf, cf});
			assertEquals(bf, view.getCurrentPublishFrom());
			assertTrue(!mgr.getBrowseAction(af).isChecked());
			assertTrue(mgr.getBrowseAction(bf).isChecked());
			assertTrue(!mgr.getBrowseAction(cf).isChecked());
			
			// other location input
			view.browse( WebpubPlugin.getLocalPath("plugin.xml") );
			waitForLoad();
			assertTrue(!mgr.getBrowseAction(af).isChecked());
			assertTrue(!mgr.getBrowseAction(bf).isChecked());
			assertTrue(!mgr.getBrowseAction(cf).isChecked());
		}finally{
			view.getSite().getPage().closeAllEditors(false);
			WebpubTestPlugin.forceDelete(proj);
		}
	}
	
	public void assertRegistedFiles(IFile[] files){
		assertRegistedFiles(view, files);
	}
	
	public static void assertRegistedFiles(HTPreView view, IFile[] files){
		IFile[] fs = view.getLinkWithEditorManager().getRegistedFiles();
		Arrays.sort(files, WebpubPlugin.RESOURCE_COMPARATOR);
		Arrays.sort(fs, WebpubPlugin.RESOURCE_COMPARATOR);
		UITestUtils.whileReadAndDispatch();
		assertTrue(toString(fs),Arrays.equals(files, fs));
	}
	
	static String toString(IResource[] rs){
		StringBuffer buff = new StringBuffer();
		for (int i = 0; i < rs.length; i++) {
			if(i != 0)
				buff.append(',');
			buff.append( rs[i].toString() );
		}
		return buff.toString();
	}
	
	
	
}
