/*
 * $Id: PublishMappingBlockTest.java,v 1.3 2004/06/07 06:46:43 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.tests.properties;

import java.util.Stack;

import junit.framework.TestCase;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.*;
import org.eclipse.swt.widgets.Shell;

import com.narucy.webpub.core.*;
import com.narucy.webpub.core.tests.WebpubTestPlugin;
import com.narucy.webpub.ui.properties.PublishMappingBlock;

/**
 * TODO: implements PublishDescriptionDifinitionBlock test
 */
public class PublishMappingBlockTest extends TestCase {

	public void testPublishDescriptionDifinitionBlock() throws Exception {
		final Stack stack = new Stack();
		
		WebProject wp = WebpubTestPlugin.createTestProject("test_projects/TemplateTest-UTF-8");
		Shell sh = new Shell();
		try{
			IFile file = wp.getFolder(WebProject.HTSOURCES_FOLDER).getFile(new Path(".publish"));
			assertFalse(file.exists());
			
			PublishMappingBlock block = new PublishMappingBlock(sh, file, new IStatusChangeListener() {
				public void statusChanged(IStatus status) {
					stack.add(status);
				}
			});
			
			//UITestUtils.displayShell(sh);
		}finally{
			sh.dispose();
			WebpubTestPlugin.forceDelete(wp.getProject());
		}
	}
}
