/*
 * $Id: MapEditDialogTest.java,v 1.7 2004/06/07 06:46:43 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.tests.properties;

import java.util.HashMap;

import junit.framework.TestCase;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.*;

import com.narucy.webpub.ui.properties.MapEditDialog;
import com.narucy.webpub.ui.tests.UITestUtils;

/**
 * <ul>
 * <li>table rows none selected when enable buttons only entry add button.
 * <li>first row selected when only disable move up button.
 * <li>last row selected when only disable move down button.
 * <li>add button pressed when open key input dialog, and insert to before
 * selected index. (if no selected row, insert to last index.)
 * <li>remove button pressed when select is removed.
 * <li>up button pressed when selected item is up.
 * <li>down button pressed when selected item is down.
 * <li>table edit button pressed when button state realtime refreshed.
 * <li>convert object. constructor specified map to string array of array that
 * represent a table that getting with getResult method.
 * </ul>
 */
public class MapEditDialogTest extends TestCase {

	public MapEditDialogTest(String name) {
		super(name);
	}

	public void testGetResult() {
		Shell shell = new Shell();
		try{
			// prepare
			HashMap map = new HashMap();
			map.put("1", "100");
			map.put("2", "200");
			map.put("3", "300");
			map.put("4", "400");
			
			MapEditDialog dialog = new MapEditDialog(shell, map);
			dialog.setBlockOnOpen(false);
			dialog.open();
			
			Shell sh = dialog.getShell();
			
			Table table = (Table)UITestUtils.findControl(sh, Table.class);
			Button addButton = (Button)UITestUtils.findControl(sh, "addButton");
			Button removeButton = (Button)UITestUtils.findControl(sh, "removeButton");
			Button upButton = (Button)UITestUtils.findControl(sh, "upButton");
			Button downButton = (Button)UITestUtils.findControl(sh, "downButton");
			
			// first, none selection rows
			while(!sh.getDisplay().readAndDispatch());
			assertEquals(0, table.getSelectionCount());
			assertTrue( addButton.isEnabled());
			assertFalse( removeButton.isEnabled());
			assertFalse( upButton.isEnabled());
			assertFalse( downButton.isEnabled());
			
			// result data test
			assertEquals(
					new String[][]{
						{"1", "100"},
						{"2", "200"},
						{"3", "300"},
						{"4", "400"},
					},
					dialog.getValues() );
			
			// first index selected
			dialog.setSelectionIndex(0);
			while(!sh.getDisplay().readAndDispatch());
			assertTrue( addButton.isEnabled());
			assertTrue( removeButton.isEnabled());
			assertFalse( upButton.isEnabled());
			assertTrue( downButton.isEnabled());
			
			// last index selected
			dialog.setSelectionIndex(3);
			while(!sh.getDisplay().readAndDispatch());
			assertTrue( addButton.isEnabled());
			assertTrue( removeButton.isEnabled());
			assertTrue( upButton.isEnabled());
			assertFalse( downButton.isEnabled());
			
			// move up
			for(int i=0; i<3; i++)
				upButton.notifyListeners(SWT.Selection, null);
			
			assertEquals(
					new String[][]{
						{"4", "400"},
						{"1", "100"},
						{"2", "200"},
						{"3", "300"},
					},
					dialog.getValues() );
			
			assertEquals(0, table.getSelectionIndex());
			
			// move down
			for(int i=0; i<3; i++)
				downButton.notifyListeners(SWT.Selection, null);
			assertEquals(
					new String[][]{
						{"1", "100"},
						{"2", "200"},
						{"3", "300"},
						{"4", "400"},
					},
					dialog.getValues() );
		}finally{
			shell.dispose();
		}
	}
	
	void assertEquals(Object[][] a, Object[][] b){
		while(!Display.getCurrent().readAndDispatch());
		
		assertEquals(a.length, b.length);
		for(int i=0; i<a.length; i++){
			for(int j=0; j<a[0].length; j++){
				assertEquals("[" + i + "," + j + ":" + a[i][j] + " = " + a[i][j] + "]",  a[i][j], b[i][j]);
			}
		}
	}
	
}
