/*
 * $Id: RubyInterpreterPreferencePageTest.java,v 1.3 2004/06/07 06:46:43 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.tests.preferences;

import junit.framework.TestCase;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.*;

import com.narucy.webpub.ui.WebpubUIPlugin;
import com.narucy.webpub.ui.preferences.RubyInterpreterPreferencePage;
import com.narucy.webpub.ui.tests.UITestUtils;

/**
 * 
 */
public class RubyInterpreterPreferencePageTest extends TestCase {

	public void testCreateContentsComposite() {
		RubyInterpreterPreferencePage page = new RubyInterpreterPreferencePage();
		Shell sh = new Shell();
		try{
			page.createControl(sh);
			Table table = (Table)UITestUtils.findControl(sh, "RubyInterpreterPreferencePage.infoTable");
			Text text = (Text)UITestUtils.findControl(sh, "RubyInterpreterPreferencePage.interpreterLocation");
			
			assertEquals(3, table.getItemCount());
			assertEquals(3, table.getColumnCount());
			String[][] vals = getTableValues(table);
			assertEquals("amrita", vals[0][0]);
			assertEquals("interpreter", vals[1][0]);
			assertEquals("rd", vals[2][0]);
			for (int i = 0; i < vals.length; i++) {
				assertEquals("OK", vals[i][2]);
			}
			assertTrue(page.isValid());
			
			text.setText("/");
			text.notifyListeners(SWT.Modify, null);
			
			UITestUtils.whileReadAndDispatch();
			vals = getTableValues(table);
			assertEquals(1, vals.length);
			assertEquals("interpreter", vals[0][0]);
			assertEquals("Error", vals[0][2]);
			
			// UITestUtils.displayShell(sh);
		}finally{
			sh.dispose();
		}
	}
	
	String[][] getTableValues(Table table){
		String[][] vals = new String[table.getItemCount()][table.getColumnCount()];
		for(int row=0; row<vals.length; row++){
			for(int col=0; col<vals[0].length; col++){
				vals[row][col] = table.getItem(row).getText(col);
			}
		}
		return vals;
	}
	
	protected void tearDown() throws Exception {
		WebpubUIPlugin
			.getDefault()
			.getPreferenceStore()
			.setToDefault( WebpubUIPlugin.RUBY_INTERPRETER_LOCATION);
	}
}
