/*
 * $Id: StringDividerTest.java,v 1.2 2004/05/24 12:12:12 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.tests.editors.html.wizards;

import junit.framework.TestCase;

import com.narucy.webpub.ui.editors.html.wizards.StringDivider;

/**
 * 
 */
public class StringDividerTest extends TestCase {

	public StringDividerTest(String name) {
		super(name);
	}
	
	public void testDivide(){
		StringDivider divider = new StringDivider();
		
		String[][] cells = divider.divide("a b c d e\nf g h\ni", "\\s+");
		assertEquals(new String[][] {
				{"a", "b", "c", "d", "e"},
				{"f", "g", "h", "",  ""},
				{"i", "", "", "",  ""},
		}, cells);
		
		cells = divider.divide("a\nb\tc\td\ne\tf\tg\th\ti", "\\s+");
		assertEquals(new String[][]{
				{"a", "", "", "", ""},
				{"b", "c", "d", "",  ""},
				{"e", "f", "g", "h",  "i"},
		}, cells);
		
		String s = "1\t2\t3\n4 4\t5\t6\n7\t8\t9 9 9 9";
		assertEquals("\t", divider.getDivideSuitedRegexp(s));
		
		cells = divider.divide(s);
		assertEquals(new String[][]{
				{"1", "2", "3"},
				{"4 4", "5", "6"},
				{"7", "8", "9 9 9 9"},
		}, cells);
		
		s = "1 1 1 1 1,2,3\n4,5\t5,6\n7,8,9";
		assertEquals(",", divider.getDivideSuitedRegexp(s));
		
		cells = divider.divide(s);
		assertEquals( new String[][] {
				{"1 1 1 1 1", "2", "3"},
				{"4", "5\t5", "6"},
				{"7", "8", "9"},
		}, cells);
		
		cells = divider.divide("A or X,B,,C\nD,,E,F");
		assertEquals(new String[][]{
				{"A or X", "B", "", "C"},
				{"D", "", "E", "F"},
		}, cells);
	}

	void assertEquals(String[][] a, String[][] b){
		assertEquals(a.length, b.length);
		for (int i = 0; i < a.length; i++) {
			assertEquals(a[i].length, b[i].length);
			for (int j = 0; j < a[i].length; j++) {
				assertEquals("(" + j + "," + i + ")",  a[i][j], b[i][j]);
			}
		}
	}
	
}
