/*
 * $Id: HTContentAssistEngineTest.java,v 1.1 2004/04/11 08:39:55 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.tests.editors.html;

import java.util.Arrays;

import junit.framework.TestCase;

import com.narucy.webpub.ui.editors.html.HTContentAssistEngine;

/**
 * HTContentAssistEngine provides 
 */
public class HTContentAssistEngineTest extends TestCase {

	public HTContentAssistEngineTest(String name) {
		super(name);
	}
	
	public void testTransitional() throws Exception {
		HTContentAssistEngine engine = new HTContentAssistEngine(HTContentAssistEngine.XHTML_TRANSITIONAL);
		String[] elements = engine.getCandidateElements("body");
		assertEquals(67, elements.length);
	}
	
	public void testCandidateAttribute() throws Exception {
		HTContentAssistEngine engine = new HTContentAssistEngine(HTContentAssistEngine.XHTML_STRICT);

		String[] attrs = engine.getCandidateAttribute("a");
		assertEquals(30, attrs.length);

		attrs = engine.getCandidateAttribute("div");
		assertEquals(16, attrs.length);
	}
	
	public void testCandidateElements() throws Exception {
		HTContentAssistEngine engine = new HTContentAssistEngine(HTContentAssistEngine.XHTML_STRICT);
		
		assertTrue(Arrays.equals(
				new String[]{"body", "head"},
				engine.getCandidateElements("html")) );

		assertEquals(22, engine.getCandidateElements("body").length);
		assertEquals(36, engine.getCandidateElements("span").length);
		
		assertTrue( Arrays.equals(
				new String[]{"td", "th"},
				engine.getCandidateElements("tr")) );
		
		assertNull(engine.getCandidateElements("foo"));
	}
	
}
