/*
 * $Id: WorkbenchTocAdapterFactoryTest.java,v 1.4 2004/06/07 06:46:43 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.tests;

import java.util.Arrays;

import junit.framework.TestCase;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.tests.WebpubTestPlugin;
import com.narucy.webpub.core.toc.*;

/**
 * <ul>
 * <li>tests toc item.
 * </ul>
 */
public class WorkbenchTocAdapterFactoryTest extends TestCase {

	public WorkbenchTocAdapterFactoryTest(String name) {
		super(name);
	}

	public void testGetAdapter() throws Exception {
		WebProject wp = WebpubTestPlugin.createTestProject("test_projects/SitemapTest");
		try{
			Toc toc = wp.getToc( wp.getTocFiles()[0] );
			
			IWorkbenchAdapter adapter = (IWorkbenchAdapter)toc.getAdapter(IWorkbenchAdapter.class);
			Object[] subTopics = adapter.getChildren(toc);
			Topic[] subTopics2 = toc.getSubtopics();
			
			assertTrue(Arrays.equals(subTopics, subTopics2));
			
			for (int i = 0; i < subTopics2.length; i++) {
				Topic t = subTopics2[i];
				IWorkbenchAdapter a = (IWorkbenchAdapter)t.getAdapter(IWorkbenchAdapter.class);
				ImageDescriptor desc = a.getImageDescriptor(t);
				assertNotNull(desc);
			}
		}finally{
			WebpubTestPlugin.forceDelete(wp.getProject());
		}
	}
	
}
