/*
 * $Id: HTParserTest.java,v 1.3 2004/06/07 06:46:43 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.tests;

import junit.framework.TestCase;

import org.eclipse.jface.text.*;

import com.narucy.webpub.ui.HTParser;

/**
 * 
 */
public class HTParserTest extends TestCase {

	public HTParserTest(String name) {
		super(name);
	}

	public void testChooseElementName() throws Exception {
		Document doc = new Document("<div>\n\n<br />\n<p>\na\nb\nc\n</p>\n\n</div>");
		
		assertEquals('<', doc.getChar(14));
		ITextSelection s = HTParser.getElementRange(doc, 14); // |<p>
		String  l = s.getText();
		assertEquals("<p>\na\nb\nc\n</p>", l);
		assertEquals("p", HTParser.chooseElementName(l) );

		s = HTParser.getElementRange(doc, 15); // <|p>
		l = s.getText();
		assertEquals("<p>\na\nb\nc\n</p>", l);
		assertEquals("p", HTParser.chooseElementName(l) );
		
		s = HTParser.getElementRange(doc, 16); // <p|>
		l = s.getText();
		assertEquals("<p>\na\nb\nc\n</p>", l);
		assertEquals("p", HTParser.chooseElementName(l) );

		s = HTParser.getElementRange(doc, 16); // <p>|
		l = s.getText();
		assertEquals("<p>\na\nb\nc\n</p>", l);
		assertEquals("p", HTParser.chooseElementName(l) );

		s = HTParser.getElementRange(doc, 18); // <p>\n|
		l = s.getText();
		assertEquals("<p>\na\nb\nc\n</p>", l);
		assertEquals("p", HTParser.chooseElementName(l) );
		
		s = HTParser.getElementRange(doc, 21); // <p>\n|
		l = s.getText();
		assertEquals("<p>\na\nb\nc\n</p>", l);
		assertEquals("p", HTParser.chooseElementName(l) );
		
		// div
		s = HTParser.getElementRange(doc, 0); // |<div>
		l = s.getText();
		assertEquals( doc.get(), l);
		assertEquals("div", HTParser.chooseElementName(l) );

		s = HTParser.getElementRange(doc, 2); // <d|iv>
		l = s.getText();
		assertEquals( doc.get(), l);
		assertEquals("div", HTParser.chooseElementName(l) );
		
		s = HTParser.getElementRange(doc, 5); // <div>|
		l = s.getText();
		assertEquals( doc.get(), l);
		assertEquals("div", HTParser.chooseElementName(l) );
		
		s = HTParser.getElementRange(doc, 7); // |<br />
		l = s.getText();
		assertEquals( "<br />", l);
		assertEquals("br", HTParser.chooseElementName(l) );

		s = HTParser.getElementRange(doc, 11); // <br |/>
		l = s.getText();
		assertEquals( "<br />", l);
		assertEquals("br", HTParser.chooseElementName(l) );

		s = HTParser.getElementRange(doc, 12); // |<br /|>
		l = s.getText();
		assertEquals( "<br />", l);
		assertEquals("br", HTParser.chooseElementName(l) );

		assertEquals('\n', doc.getChar(13));
		s = HTParser.getElementRange(doc, 13); // <br />|
		l = s.getText();
		assertEquals( doc.get(), l);
		assertEquals("div", HTParser.chooseElementName(l) );
	}

	public void testNestedElem() throws Exception {
		Document doc = new Document("<p><div><span>a</span></div> <span><br /></span></p>");
		
		assertEquals(' ', doc.getChar(28));
		ITextSelection s = HTParser.getElementRange(doc, 28);// </div>|
		String l = s.getText();
		assertEquals(doc.get(), l);
		assertEquals("p", HTParser.chooseElementName(l) );
		
		s = HTParser.getElementRange(doc, 27);// </div|>
		l = s.getText();
		assertEquals("<div><span>a</span></div>", l);
		assertEquals("div", HTParser.chooseElementName(l) );
		
		s = HTParser.getElementRange(doc, 23);// <|/div>
		l = s.getText();
		assertEquals("<div><span>a</span></div>", l);
		assertEquals("div", HTParser.chooseElementName(l) );
		
		s = HTParser.getElementRange(doc, 22);// |</div>
		l = s.getText();
		assertEquals("<div><span>a</span></div>", l);
		assertEquals("div", HTParser.chooseElementName(l) );
	}

	public void testWithComment() throws Exception {
		Document doc = new Document("<p><div><!-- a --><span>a</span></div> <!-- b --><span><br /></span><!-- c --></p>");
		
		assertFalse( HTParser.isInToken(doc, 0));
		assertTrue( HTParser.isInToken(doc, 1));
		assertTrue( HTParser.isInToken(doc, 2));
		assertFalse( HTParser.isInToken(doc, 3));
		
		assertTrue( HTParser.isInToken(doc, 7)); // <p><div|><!--
		assertFalse( HTParser.isInToken(doc, 8)); // <p><div>|<!--
		assertFalse( HTParser.isInToken(doc, 9)); // <p><div><|!--
		assertFalse( HTParser.isInToken(doc, 10)); // <p><div><!|--
		
		ITextSelection s = HTParser.getElementRange(doc, 10);
		String l = s.getText();
		assertEquals("<div><!-- a --><span>a</span></div>", l);
		assertEquals("div", HTParser.chooseElementName(l));
		
		assertEquals("div", HTParser.getElementName(doc, 10));
		assertEquals("p", HTParser.chooseElementName(doc, 10, 1));
		
		s = HTParser.getElementRange(doc, 38);
		l = s.getText();
		assertEquals(doc.get(), l);
		assertEquals("p", HTParser.chooseElementName(l));
		
		assertEquals('b', doc.getChar(56));
		assertEquals("<br />", HTParser.getElementRange(doc, 56).getText() );
		assertEquals("<span><br /></span>", HTParser.getElementRange(doc, 56, 1).getText() );
		assertEquals("<p><div><!-- a --><span>a</span></div> <!-- b --><span><br /></span><!-- c --></p>", HTParser.getElementRange(doc, 56, 2).getText() );
	}

}