/*
 * $Id: Topic.java,v 1.5 2004/06/07 06:46:36 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.toc;

import java.util.*;

import org.eclipse.core.runtime.PlatformObject;

/**
 * 
 */
public class Topic extends PlatformObject {

	final public static String
		HREF = "href",
		LABEL = "label";
	
	ArrayList topics = new ArrayList();
	Topic parent = null;
	HashMap attributes = new HashMap();

	protected Topic(String href, String label, Topic parent) {
		setParent(parent);
		setAttribute(HREF, href);
		setAttribute(LABEL, label);
	}

	protected void setParent(Topic parent){
		if(this instanceof Toc){
			return;
		}
		if(parent == null){
			throw new IllegalArgumentException("Null argument");
		}
		this.parent = parent;
	}

	public String getAttribute(String key){
		return (String)attributes.get(key);
	}

	public void setAttribute(String key, String value){
		Object v = attributes.get(key);
		if( v == value || (v != null ? v.equals(value) : value.equals(v)) ){
			return;
		}
		if(value == null){
			attributes.remove(key);
		}else{
			attributes.put(key, value);
		}
		
		getToc().stockEvent(new TocEvent(
			TocEvent.ATTR_CHANGED,
			this,
			parent,
			parent != null ? parent.indexOf(this) : -1));
	}
	
	public String[] getAttributeKeys(){
		return (String[])attributes.keySet().toArray(new String[attributes.size()]);
	}

	public String getHref() {
		return getAttribute(HREF);
	}

	public String getLabel() {
		return getAttribute(LABEL);
	}
	
	public void setHref(String string) {
		setAttribute(HREF, string);
	}

	public void setLabel(String string) {
		setAttribute(LABEL, string);
	}
	
	public void addTopic(Topic topic){
		addTopic(topics.size(), topic);
	}

	public void addTopic(int index, Topic topic){
		topics.add(index, topic);
		topic.setParent(this);
		getToc().stockEvent(new TocEvent(TocEvent.ADDED, topic, this, index));
	}

	public void removeTopic(Topic topic){
		int index = topics.indexOf(topic);
		if(index != -1){
			topics.remove(index);
			getToc().stockEvent(new TocEvent(TocEvent.REMOVED, topic, this, index));
		}
	}

	public Topic[] getSubtopics() {
		return (Topic[])topics.toArray(new Topic[topics.size()]);
	}
	
	public int getSubtopicCount(){
		return topics.size();
	}
	
	public boolean hasSubtopics(){
		return !topics.isEmpty();
	}
	
	public Topic getParent(){
		return parent;
	}

	public int indexOf(Topic t){
		return topics.indexOf(t);
	}

	public Topic getNextTopic(boolean overLevel){
		Topic[] topics = overLevel ? getToc().getAllTopics() :
			parent != null ? parent.getSubtopics() : null;
		
		for(int i=0; topics != null && i<topics.length-1; i++){
			if(topics[i].equals(this)){
				return (Topic)topics[i+1];
			}
		}
		return null;
	}

	public Topic getPrevTopic(boolean overLevel){
		Topic[] topics = overLevel ? getToc().getAllTopics() :
			parent != null ?
				parent.getSubtopics() : null;
		
		for(int i=1; topics != null && i<topics.length; i++){
			if(topics[i].equals(this)){
				return (Topic)topics[i-1];
			}
		}
		return null;
	}
	
	public boolean moveUp(){
		int index = parent.indexOf(this);
		if(index > 0){
			parent.removeTopic(this);
			parent.addTopic(index-1, this);
			return true;
		}
		return false;
	}
	
	public boolean moveDown(){
		try{
			int index = parent.indexOf(this);
			if(index < parent.getSubtopicCount()-1){
				parent.removeTopic(this);
				parent.addTopic(index+1, this);
				return true;
			}
		}catch(NullPointerException e){
			e.printStackTrace();
		}
		return false;
	}
	
	public boolean levelUp(){
		Topic p = parent;
		int beforeIndex = p.indexOf(this);
		
		Topic newParent = getPrevTopic(false);
		if(newParent != null){
			parent.removeTopic(this);
			newParent.addTopic(newParent.getSubtopicCount(), this);
			return true;
		}
		return false;
	}
	
	public boolean levelDown(){
		Topic p = parent;
		int beforeIndex = p.indexOf(this);
		
		Topic parentOfParent = p.getParent();
		if(parentOfParent != null){
			int index = parentOfParent.indexOf(p);
			p.removeTopic(this);
			parentOfParent.addTopic(index+1, this);
			return true;
		}
		return false;
	}

	public Toc getToc(){
		for(Topic t = this; t != null; t = t.getParent() ){
			if(t instanceof Toc){
				return (Toc)t;
			}
		}
		return null;
	}

	public Topic createTopic(String href, String label) {
		Topic topic = new Topic(href, label, this);
		addTopic(topic);
		return topic;
	}

	public boolean equals(Object obj) {
		if(obj == null || !getClass().equals(obj.getClass())){
			return false;
		}
		Topic other = (Topic)obj;
		
		String[] keys = getAttributeKeys();
		for (int i = 0; i < keys.length; i++) {
			String k = keys[i];
			if(!getAttribute(k).equals(other.getAttribute(k))){
				return false;
			}
		}
		
		Topic[] topics = getSubtopics();
		Topic[] otherTopics = other.getSubtopics();
		
		return Arrays.equals(topics, otherTopics);
	}
	
	public Object clone() {
		Topic newTopic = new Topic(getHref(), getLabel(),  parent);
		
		String[] keys = getAttributeKeys();
		for (int i = 0; i < keys.length; i++) {
			String k = keys[i];
			newTopic.setAttribute(k, getAttribute(k));
		}
		
		Topic[] ts = getSubtopics();
		for (int i = 0; i < ts.length; i++) {
			newTopic.addTopic( (Topic)ts[i].clone() );
		}
		return newTopic;
	}

}
