/*
 * $Id: PublishMapping.java,v 1.6 2004/06/07 06:46:35 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.publish;

import java.util.*;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.*;

import com.narucy.webpub.core.Wildcard;

/**
 * PublishMapping roles definication publish location and publish method.
 */
public class PublishMapping {

	Map argument;
	IFile propFile;
	String by;
	
	IPath matchPattern, publishTo;

	public PublishMapping(IFile propFile, Map args) throws IllegalConfigurationException {
		this.propFile = propFile;
		argument = args;
		by = (String)argument.remove("by");
		if(by == null){
			throw new IllegalConfigurationException("specify map is not contain \"by\":" + args);
		}
		String ptn = (String)args.remove("pattern");
		if(ptn == null){
			throw new IllegalConfigurationException("specify map is not contain \"pattern\":" + args);
		}
		matchPattern = Wildcard.containWildcardSymble(ptn) ?
				new Wildcard(ptn) :
				new Path(ptn);
		
		String pubTo = (String)args.remove("publish_to");
		publishTo = pubTo == null ?
				null :
				Wildcard.containWildcardSymble(pubTo) ?
						new Wildcard(pubTo) :
						new Path(pubTo);
	}
	
	public IFile getPropertyFile(){
		return propFile;
	}
	
	public IPath getMatchPattern(){
		return matchPattern;
	}
	
	public IPath getPublishTo(){
		return publishTo;
	}
	
	public String getPublishBy(){
		return by;
	}
	
	public Map getArguments(){
		return new HashMap(argument);
	}

}
