/*
 * $Id: AmritaErrorHandler.java,v 1.7 2004/06/07 06:46:35 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.publish;

import java.util.regex.*;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.CoreException;

import com.narucy.webpub.core.RubyException;

/**
 * 
 */
class AmritaErrorHandler extends PublishErrorHandler {

	protected IMarker createMarker(IResource res, RubyException ex) throws CoreException {
		IMarker marker = super.createMarker(res, ex);
		
		// handling with script error
		Pattern htParseErrorPattern = Pattern.compile(".*" + res.getName() + ":(\\d+).*");
		Matcher matcher = htParseErrorPattern.matcher(ex.getMessage());
		if(matcher.matches()){
			// parse error handline
			marker.setAttribute(IMarker.LINE_NUMBER, Integer.parseInt(matcher.group(1)));
			return marker;
		}else{
			// script error handle
			IMarker scriptMarker = createMarkerAsScript(res.getProject(), ex);
			if(scriptMarker != null){
				marker.setAttribute(PublisherBuilder.ATTR_RELATE_RESOURCE, scriptMarker.getResource().getFullPath().toString());
			}
		}
		
		return marker;
	}

}
