/*
 * $Id: Preset.java,v 1.8 2004/06/07 06:46:38 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.preset;

import java.io.*;
import java.net.URL;
import java.util.*;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;

import com.narucy.webpub.core.WebProject;


public abstract class Preset {

	final static String[] EXCLUDE_PROP_KEYS = {
			WebProject.HTSOURCES_FOLDER,
			WebProject.SCRIPTS_FOLDER,
			WebProject.PUBLISH_FOLDER,
	};
	
	static {
		Arrays.sort(EXCLUDE_PROP_KEYS);
	}
	
	Properties webProjectProp;
	
	URL baseDirectory;
	String name, description;
	
	public Preset(URL baseDirectory, String name, String description) {
		this.baseDirectory = baseDirectory;
		this.name = name;
		this.description = description;
	}
	
	public URL getBaseDirectory() {
		return baseDirectory;
	}

	public String getDescription() {
		return description;
	}
	
	public String getName() {
		return name;
	}
	
	final public WebProject distribute(final IProject proj, final String htSourcesFolder, final String scriptsFolder, final String publishFolder, IProgressMonitor monitor) throws CoreException {
		final WebProject[] webProj = {null};
		proj.getWorkspace().run(new IWorkspaceRunnable() {
			public void run(IProgressMonitor moni) throws CoreException {
				webProj[0] = internalDistribute(proj, htSourcesFolder, scriptsFolder, publishFolder, moni);
			}
		}, monitor);
		return webProj[0];
	}
	
	WebProject internalDistribute(IProject proj, String htSourcesFolder, String scriptsFolder, String publishFolder, IProgressMonitor monitor) throws CoreException {
		monitor.beginTask("create new project", 4);
		try{
			WebProject wp = WebProject.distributeNewProject(
					proj,
					htSourcesFolder,
					scriptsFolder,
					publishFolder,
					new SubProgressMonitor(monitor, 1));
			
			distribute(wp, new SubProgressMonitor(monitor, 1));
			Object[] presetWebProjectPropKeys = webProjectProp.keySet().toArray();
			for (int i = 0; i < presetWebProjectPropKeys.length; i++) {
				String k = (String)presetWebProjectPropKeys[i];
				String v = webProjectProp.getProperty(k);
				if(Arrays.binarySearch(EXCLUDE_PROP_KEYS, k) < 0 && v.length() > 0){
					wp.setValue(k, v);
				}
			}
			wp.storePreferences();
			
			proj.refreshLocal(
					IResource.DEPTH_INFINITE,
					new SubProgressMonitor(monitor, 1));
			
			proj.build(
					IncrementalProjectBuilder.FULL_BUILD,
					new SubProgressMonitor(monitor, 1));
			
			return wp;
		}finally{
			monitor.done();
		}
	}
	
	protected void loadProperty(InputStream stream) throws IOException{
		webProjectProp = new Properties();
		webProjectProp.load(stream);
	}
	
	public Properties getWebProjectProperty(){
		return webProjectProp;
	}
	
	protected abstract void distribute(WebProject webProject, IProgressMonitor monitor) throws CoreException;

	protected static void createFolder(IFolder folder, IProgressMonitor monitor) throws CoreException{
		monitor.beginTask("create folder", 1000);
		try{
			ArrayList folders = new ArrayList();
			for(IContainer c = folder; !c.exists(); c = c.getParent()){
				folders.add(c);
			}
			if(folders.size() > 0){
				int ratio = 1000 / folders.size();
				for(int j=folders.size()-1; j>=0; j--){
					((IFolder)folders.get(j)).create(false, true, new SubProgressMonitor(monitor, ratio));
				}
			}
		}finally{
			monitor.done();
		}
	}
	
}
