/*
 * $Id: WebpubPlugin.java,v 1.13 2004/06/07 06:46:35 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core;

import java.io.*;
import java.net.URL;
import java.util.*;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.*;
import org.osgi.framework.Bundle;

/**
 * WebpubPlugin has base data of the plugin.
 */
public class WebpubPlugin extends Plugin {

	final public static Comparator RESOURCE_COMPARATOR = new Comparator() {
		public boolean equals(Object obj) {
			return false;
		}
		public int compare(Object a, Object b) {
			return ((IResource)a).getFullPath().toString().compareTo(((IResource)b).getFullPath().toString());
		}
	};

	final public static String
		ID_PLUGIN = "com.narucy.webpub.core";

	final static String[] defaultFindPath = {
		System.getProperty("user.rubypath"),
		"c:/ruby-1.8.1-i386-mingw32/usr/local/bin",
		"c:/ruby-1.8.1-i386-cygwin/usr/local/bin",
		"c:/ruby-1.8.1-i386-mswin32/usr/local/bin",
		"c:/ruby/bin",
		"c:/cygwin/usr/local/bin",
		"c:/cygwin/usr/bin",
		"c:/cygwin/bin",
		"/usr/local/bin",
		"/usr/bin",
		"/bin",
	};
	
	final static String[] interpreterFileNames = {
		"rubyw.exe",
		"ruby",
	};

	static WebpubPlugin plugin;
	ResourceBundle resourceBundle;
	
	IPath rubyCommandPath = findInitialInterpreter();
	String initialCommandLineOption;

	public WebpubPlugin() {
		plugin = this;
		try {
			resourceBundle= ResourceBundle.getBundle("webpub");
		} catch (MissingResourceException x) {
			resourceBundle = null;
		}
		initialCommandLineOption = " -I " + getLocalPath("scripts/lib");
	}
	
	public static IPath findInitialInterpreter(){
		for(int i=0; i<defaultFindPath.length; i++){
			for(int j=0; j<interpreterFileNames.length; j++){
				File file = new File(defaultFindPath[i], interpreterFileNames[j]);
				if(file.exists()){
					return new Path(file.toString());
				}
			}
		}
		return null;
	}
	
	public static WebpubPlugin getDefault(){
		return plugin;
	}
	
	public ResourceBundle getResourceBundle(){
		return resourceBundle;
	}
		
	public IPath getRubyCommandPath(){
		return rubyCommandPath;
	}
	
	public void setRubyCommandPath(IPath rubyCommandPath){
		this.rubyCommandPath = rubyCommandPath;
	}

	public Process rubyExec(String arguments, IPath workingDirectory) throws IOException {
		return WebpubPlugin.rubyExec(
				rubyCommandPath.toString(),
				initialCommandLineOption + ' ' + arguments,
				workingDirectory);
	}
	
	public static Process rubyExec(String rubyCommandPath, String arguments, IPath workingDirectory) throws IOException {
		String cmd = rubyCommandPath + ' ' +  arguments;
		return Runtime.getRuntime().exec(cmd, null, workingDirectory != null ? workingDirectory.toFile() : null);
	}
	
	public static void handleException(Exception e) {
		e.printStackTrace();
		plugin.getLog().log(new Status(IStatus.ERROR, ID_PLUGIN, IStatus.OK, e.getMessage(), e));
	}

	public static String getLocalPath(String path){
		return getLocalPath(path, Platform.getBundle(ID_PLUGIN));
	}
	
	public static String getLocalPath(String path, Bundle bundle){
		if(bundle == null){
			throw new IllegalArgumentException("specify bundle is null");
		}
    	URL url = bundle.getEntry(path);
    	try {
			url = Platform.asLocalURL(url);
		} catch (IOException e) {
			return null;
		}
    	return new File(url.getFile()).toString();
	}

}
