/*
 * $Id: TextReader.java,v 1.6 2004/06/07 06:46:36 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core;

import java.io.*;
import java.net.*;
import java.util.*;
import java.util.regex.*;

/**
 * Utility for text reader.
 */
public class TextReader implements Iterator {
	
	InputStreamReader in;
	
	BufferedReader reader = null;
	String nextLine = null;
	
	public TextReader(URL url) throws IOException {
		this(url, chooseEncoding(url));
	}

	public static String chooseEncoding(URL url) throws IOException{
		if( url.getProtocol().equals("http") ){
			Socket http = new Socket(url.getHost(), url.getDefaultPort());
			PrintWriter writer =new PrintWriter(http.getOutputStream());
			String path = url.getPath();
			if(path.length() == 0){
				path = "/";
			}
			String req = "GET " + path + " HTTP/1.0\nUser-Agent: Web Publisher\nHost: " + url.getHost() + "\n\n";
			writer.write(req);
			writer.flush();
			
			Pattern pattern = Pattern.compile(".*charset=([\\w-]+).*");
			TextReader reader = new TextReader(http.getInputStream());
			while(reader.hasNext()){
				String l = reader.nextLine();
				Matcher m = pattern.matcher( l );
				if(m.matches()){
					return m.group(1);
				}
			}
		}
		return null;
	}
	
	public TextReader(URL url, String encoding) throws IOException {
		this(url.openStream(), encoding);
	}
	
	public TextReader(InputStream stream) {
		this(stream, null);
	}

	public TextReader(InputStream stream, String encoding) {
		try{
			in = encoding != null ?
				new InputStreamReader(stream, encoding) :
				new InputStreamReader(stream);
		}catch(IOException e){
			handleException(e);
		}
	}
	
	public synchronized void close() {
		try {
			if(reader != null){
				reader.close();
			}
		} catch (IOException e) {
			handleException(e);
		}
	}
	
	public boolean hasNext(){
		if( reader == null){
			init();
		}
		return ( nextLine != null);
	}
	
	public Object next() {
		return nextLine();
	}

	void init(){
		reader = new BufferedReader(in);
		try {
			nextLine = reader.readLine();
		} catch (IOException e) {
			handleException(e);
		}
	}

	public String nextLine() {
		if(reader == null){
			init();
		}
		try{
			String current = nextLine;
			nextLine = reader.readLine();
			if( nextLine == null){
				close();
			}
			return current;
		}catch(IOException e){
			return handleException(e);
		}
	}

	public String[] toLines() {
		ArrayList list = new ArrayList();
		while(hasNext()){
			list.add( nextLine());
		}
		return (String[])list.toArray(new String[list.size()]);
	}

	public String joinedLines() {
		StringBuffer buff = new StringBuffer();
		String[] lines = toLines();
		for (int i = 0; i < lines.length; i++) {
			buff.append( lines[i] );
			buff.append('\n');
		}
		return buff.toString();
	}

	public void remove() {
	}

	protected String handleException(IOException e){
		e.printStackTrace();
		throw new RuntimeException(e);
	}

}