#
# $Id: workspace.rb,v 1.1 2004/01/17 12:02:26 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'singleton'
require 'rexml/document'
require 'webpub/webproject'

module Webpub

class Workspace

	include Singleton

	attr_reader :path

	def initialize
		@path = nil
		@project_pathes = {}
		@web_projects = Hash.new { |hash, proj_name|
			proj_path = @project_pathes[proj_name]
			hash[proj_name] = File.file?(proj_path + '/.webproject') ? Webpub::WebProject.new(proj_path) : nil
		}
	end

	def path=(path)
		@path = path ? File.expand_path(path) : nil
		
		@project_pathes.clear
		@web_projects.clear
		
		if path
			Dir.glob(@path + '/*') { |d|
				if File.directory?(d) and File.file?(f = d + '/.project')
					@project_pathes[ Workspace::choose_project_name(f) ] = d
				end
			}
			Dir.glob(@path + '/.metadata/.plugins/org.eclipse.core.resources/.projects/*/.location') { |f|
				if %r!([^/]+?)/\.location$! === f
					@project_pathes[$1] = choose_project_path(f)
				end
			}
		end
	end

	def virtual?
		!File.directory?(@path + '/.metadata')
	end

	def project_pathes
		@project_pathes.dup
	end

	def web_project(name)
		@web_projects[name]
	end

	def project_names
		@project_pathes.keys
	end
	
	def web_projects
		project_names().map { |name| web_project(name) }.compact
	end

	def Workspace::choose_project_name(file)
		doc = REXML::Document.new(IO.read(file))
		if e = doc.elements['projectDescription/name']
			e.text
		else
			nil
		end
	end

	def choose_project_path(f)
		result = ''
		byte_count = 0
		open(f, 'rb') { |fh|
			fh.each_byte { |b|
				byte_count+=1
				return File.expand_path(result) if b == 192 and byte_count >= 19
				result << b if byte_count >= 19
			}
		}
		nil
	end

end

end
