#
# $Id: webproject.rb,v 1.1 2004/01/17 12:02:26 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'webpub/workspace'
require 'webpub/publish_description_factory'

module Webpub

class WebProject

	DIRECTORY_KEYS = %w!htsources_folder scripts_folder publish_folder!
	
	def initialize(path)
		@path = File.expand_path(path)
		unless File.directory?(@path)
			raise ArgumentError, "specify path is not directory: #{@path}"
		end
		
		config_file =  @path + '/.webproject'
		unless File.file?(config_file)
			raise ArgumentError, "not found a project configription file: #{config_file}"
		end
		
		@entries = {}
		
		IO.foreach(config_file) { |line|
			if /^([^#]+?)=(.+)/ === line
				self[$1.strip] = $2.strip
			end
		}
		
		DIRECTORY_KEYS.each { |key|
			unless self[key]
				raise ArgumentError, "#{config_file} is not included entry :#{key}"
			end
		}
		
		@publish_description_factory = PublishDescriptionFactory.new(self)
	end

	attr_reader :path, :publish_description_factory, :entries

	def [](key)
		key = key.intern if key.is_a?(String)
		@entries[key]
	end
	
	def []=(key, value)
		key = key.to_s
		@entries[key.intern] = value
		DIRECTORY_KEYS.each { |k|
			dk = k.sub(/_folder$/, '_dir')
			if k == key
				@entries[dk.intern] = to_filesystem_absolute_path(value)
			elsif dk == key
				@entries[k.intern] = to_workspace_path(value)
			end
		}
	end
	
	def name
		ws = Workspace.instance
		ws.project_pathes.each { |name, path|
			return name if path.casecmp(@path) == 0
		}
		raise "workspace doesn't regist this web project"
	end

	def to_filesystem_absolute_path(p)
		if %r!^/! === p
			segments = p.split('/').select { |v| !v.empty? }
			proj_path = Workspace.instance.project_pathes[segments.shift]
			segments.unshift(proj_path).join('/')
		else
			File.join(@path, p)
		end
	end
	
	def to_workspace_path(p)
		if /^#{@path}/ === p
			p.sub(/^#{@path}\//, '')
		else
			p.sub(%r!^#{Workspace.instance.path}!, '')
		end
	end
	
end

end
