#
# $Id: install_checker.rb,v 1.1 2004/06/02 02:40:44 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

module Envchk

class InstallChecker

	NONE = 0
	INFORMATION = 1
	WARNING = 2
	ERROR = 3

	#def check
	#end
end

class InstallCheckerManager

	attr_reader :checkers

	def InstallCheckerManager::new_as_args(args)
		mgr = InstallCheckerManager.new
		
		while args.size >= 3
			name = args.shift
			load args.shift
			mgr.checkers[name] = eval(args.shift).new
		end
		mgr
	end

	def initialize
		@checkers = {}
	end
	
	def do_check
		@checkers.map { |name, checker|
			res = checker.check
			if res and !res.is_a?(Array)
				res = [res.to_s, InstallChecker::ERROR]
			end
			res = ['succeed', InstallChecker::NONE] unless res
			
			res.unshift(name)
		}
	end

	def expand_result(handle)
		do_check().each { |res|
			handle << res.join(',') + "\n"
		}
	end
	
	def dist_result(file)
		open(file, 'w') { |fh|
			expand_result(fh)
		}
	end

end

end
