#
# $Id: webproject_test.rb,v 1.1 2004/01/17 12:02:27 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'test/unit'
require 'webpub'

class WebProjectTest < Test::Unit::TestCase

	include Webpub

	def setup
		@workspace = Workspace.instance
		@workspace.path = File.dirname(__FILE__) + '/test_workspace'
	end
	
	def test_name
		proj = WebProject.new(File.dirname(__FILE__) + '/test_workspace/web_project')
		assert_equal("web_project", proj.name)
	end
	
	def test_folder
		proj_path = File.expand_path(File.dirname(__FILE__) + '/test_workspace/web_project')
		proj = WebProject.new(proj_path)
		
		assert_equal( proj_path + '/ht_sources', proj[:htsources_dir])
		assert_equal( proj_path + '/scripts', proj[:scripts_dir])
		assert_equal( proj_path + '/public_html', proj[:publish_dir])
		
		proj[:htsources_dir] = proj_path + '/foo/bar'
		assert_equal( proj_path + '/foo/bar', proj[:htsources_dir])
		assert_equal( 'foo/bar', proj[:htsources_folder])
		
		proj[:htsources_folder] = 'bar/foo'
		assert_equal( proj_path + '/bar/foo', proj[:htsources_dir])
		assert_equal( 'bar/foo', proj[:htsources_folder])
		
		proj[:publish_dir] = @workspace.path + '/bar'
		assert_equal( @workspace.path + '/bar', proj[:publish_dir])
		assert_equal( '/bar', proj[:publish_folder])
		
		proj[:publish_folder] = '/aaa'
		assert_equal( @workspace.path + '/aaa', proj[:publish_dir])
		assert_equal( '/aaa', proj[:publish_folder])
	end

	def test_create_web_project_as_over_project
		proj = WebProject.new( File.dirname(__FILE__) + '/test_workspace/aaa')
		assert %r!test_workspace/aaa/ht_sources$! === proj[:htsources_dir]
		assert %r!test_workspace/ccc$! === proj[:scripts_dir]
		assert %r!test_workspace/bbb$! === proj[:publish_dir]
	end

end
