#
# $Id: publisher_test.rb,v 1.1 2004/01/17 12:02:27 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'test/unit'
require 'webpub/publisher'
require 'tempfile'

=begin

PublisherRegistory roles are:

* It keeps publisher instances.

* Error infomation management when publisher plug-ins to registed.

* Distribute cache file for publisher script file path and script name
  for plug-in loading performance.
  (collecting plugin.xml file process is a high cost work.)

=end
class PublisherRegistoryTest < Test::Unit::TestCase

	def setup
		@reg = Webpub::PublisherRegistory.instance
		@reg.clear
		@reg.error_output = []
	end

	def test_to_fail_str
		err_line = <<EOS
(erb):4:in `z': undefined local variable or method `zzz' for main:Object (NameError)
	from (erb):8:in `y'
	from (erb):12:in `x'
	from (erb):15
EOS

		ex = Exception.new("undefined local variable or method `zzz' for main:Object (NameError)")
		ex.set_backtrace([
			"(erb):4:in `z'",
			"(erb):8:in `y'",
			"(erb):12:in `x'",
			"(erb):15",
		])
		assert_equal(err_line, Webpub::to_fail_str(ex))
	
		err_line = <<EOS
D:/desktop_administrator/x.rb:2:in `z': undefined local variable or method `zzz' for main:Object (NameError)
	from D:/desktop_administrator/x.rb:6:in `y'
	from D:/desktop_administrator/x.rb:10:in `x'
	from D:/desktop_administrator/x.rb:13
EOS
		
		ex = Exception.new("undefined local variable or method `zzz' for main:Object (NameError)")
		ex.set_backtrace([
			"D:/desktop_administrator/x.rb:2:in `z'",
			"D:/desktop_administrator/x.rb:6:in `y'",
			"D:/desktop_administrator/x.rb:10:in `x'",
			"D:/desktop_administrator/x.rb:13",
		])
		assert_equal(err_line, Webpub::to_fail_str(ex))

		ex.set_backtrace([])
		assert_equal(
			"undefined local variable or method `zzz' for main:Object (NameError)\n",
			Webpub::to_fail_str(ex) )
	end

	def test_regist_plugins
		ids = @reg.regist_plugin(File.dirname(__FILE__) + '/test_plugins/aaa')
		assert_equal(
			%w!aaa1 aaa2 aaa3!,
			ids.sort)

		ids = @reg.regist_plugin(File.dirname(__FILE__) + '/test_plugins/bbb/plugin.xml')
		assert_equal(['bbb1'], ids)
	end

	def test_collect_plugins
		assert_nil @reg['aaa1']
		ids = @reg.collect_plugins(File.dirname(__FILE__) + '/test_plugins/')
		
		assert_equal(
			%w!aaa1 aaa2 aaa3 bbb1!,
			ids.sort)
		
		assert @reg['aaa1']
		assert_equal( 'AAA1Publisher', @reg['aaa1'].class.to_s)
		
		assert_nil @reg.registed_error('aaa1')
		assert @reg.registed_error('bbb2')
		
		assert_equal(
			%w!aaa1 aaa2 aaa3 bbb1!,
			@reg.ids.sort)
		
		# tests unregist method
		@reg.unregist('aaa1')
		assert_equal(
			%w!aaa2 aaa3 bbb1!,
			@reg.ids.sort)
		
		# tests error publisher
		assert_equal(4, @reg.error_output.select { |l| /^[^\t]/ === l }.size)
		ids = @reg.regist_failed_publisher_ids
		
		assert_equal( %w!bbb2 xxx yyy zzz!, ids.sort)
	end

	def test_store_publisher_entry_file
		tmpfile = Tempfile.new(self.class.to_s)
		begin
			@reg.collect_plugins(File.dirname(__FILE__) + '/test_plugins')
			@reg.store_publisher_entry_file(tmpfile.path)
			@reg.clear
			
			assert_equal( [], @reg.ids)
			
			@reg.regist_plugins_from_entry_file(tmpfile.path)
			assert_equal(
				@reg.ids.sort,
				%w!aaa1 aaa2 aaa3 bbb1!)
		ensure
			tmpfile.close
		end
	end

end