#
# $Id: copy_publisher_test.rb,v 1.1 2004/01/17 12:02:27 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'test/unit'
require 'tempfile'
require 'fileutils'
require 'webpub'

=begin

CopyPublisher is only to copy a file.

=end
class CopyPublisherTest < Test::Unit::TestCase

	include Webpub

	def setup
		@ws_path = Dir::tmpdir + '/workspace'
		FileUtils.cp_r(File.dirname(__FILE__) + '/test_workspace', @ws_path)
		
		Workspace.instance.path = @ws_path
		PublisherRegistory.instance.regist_plugin(File.dirname(__FILE__) + '/../../../com.narucy.webpub.core/')
		
		@webproj_path = @ws_path + '/web_project'
	end

	def test_publish_by_copy
		manager = PublishManager.new
		@out = []
		manager.listeners << ConsoleResultDistributer.new(@out)
		
		oks, fails = manager.publish( Dir.glob(@webproj_path + '/ht_sources/imgs/*') )
		assert_equal(3, oks.size)
		assert(fails.empty?)
		assert_equal(3, @out.size)
		@out.each { |l|
			assert /^<<<OK/ === l
		}
		files = Dir.glob(@webproj_path + '/public_html/imgs/*')
		assert_equal(3, files.size)
	end

	def teardown
		FileUtils.rm_r(@ws_path)
	end

end
