#
# $Id: amrita_wz_rd_publisher_test.rb,v 1.1 2004/01/17 12:02:26 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'tempfile'
require 'test/unit'
require 'fileutils'
require 'webpub'

=begin

AmritaWzRDPublisher

=end
class AmritaWzRDPublisherTest < Test::Unit::TestCase

	include Webpub
	
	def setup
		@ws_path = Dir::tmpdir + '/workspace'
		FileUtils.cp_r(File.dirname(__FILE__) + '/test_workspace', @ws_path)
		
		Workspace.instance.path = @ws_path
		PublisherRegistory.instance.regist_plugin(File.dirname(__FILE__) + '/../../../com.narucy.webpub.core/')
		
		@webproj_path = @ws_path + '/web_project'
	end

	def test_publish_by_rd_with_tmpl
		manager = PublishManager.new
		@out = []
		manager.listeners << ConsoleResultDistributer.new(@out)
		oks, failed = manager.publish( Dir.glob(@webproj_path + '/rd/with_tmpl/*.rd') )
		
		# @out
		
		assert_equal(1, oks.size)
		assert_equal(0, failed.size)
		
		assert_equal(1, @out.size)
		assert /,amrita_wz_rd,/ === @out[0]
		
		putfile = @webproj_path +'/public_html/pub_rd/amrita_wz_rd.html'
		lines = File.read(putfile)
		
		assert %r!<p>3rd RD.</p>! === lines
	end

	def teardown
		FileUtils.rm_r(@ws_path)
	end

end
