# $Id: generation_test.rb,v 1.1 2004/01/17 12:02:32 hn Exp $
# Copyright Narushima Hironori. All rights reserved.

require 'test/unit'
require 'sitemapper/generator'

class SitemapGeneratorTest < Test::Unit::TestCase

	include SiteMapper

	def setup
		@gene = SitemapGenerator.new
		@file = File.join(File.dirname(__FILE__), 'toc.test.xml')
	end

	def test_illgeal_arguments
		err = nil
		begin
			code = @gene.gen(@file, 'foo')
		rescue ArgumentError => err
		end
		assert err
	end

	def test_generate
		code = @gene.gen(@file)
		assert(%r!<a href="home.html">Home Page</a>! === code)
		
		code = @gene.gen(@file, 'test1/a.html')
		assert !(%r[<a href="home.html"></a>] === code)
	end

end
