# $Id: navigation_test.rb,v 1.1 2004/01/17 12:02:32 hn Exp $
# Copyright Narushima Hironori. All rights reserved.

require 'test/unit'
require 'fileutils'
require 'tempfile'

require 'amrita/template'

require 'webpub/workspace'
require 'webpub/publisher'
require 'sitemapper/navigation'
require 'amritatmpl/navipage'

class NaviPageTest < Test::Unit::TestCase

	include Webpub

	def setup
		@proj_path = Dir::tmpdir + '/navi_test_project'
		
		FileUtils.cp_r(File.dirname(__FILE__) + '/navi_test_project', @proj_path)
		@workspace = Webpub::Workspace.instance
		@workspace.path = @proj_path + '/..'
	end

	def test_data
		wp = @workspace.web_project('navi_test_project')
		desc = PublishDescription.new('amrita', wp)
		
		# a.html
		desc.publish_from = wp[:htsources_dir] + '/a.html'
		desc.publish_to = wp[:publish_dir] + '/a.html'
		data = NaviPage.new(desc)
		
		assert_equal({:title => data[:start_title], :url => data[:start_url]}, data[:start])
		assert_nil(data[:chapter])
		
		assert_equal('A', data[:start_title])
		assert_equal('a.html', data[:start_url])
		
		assert_equal({:title => data[:next_title], :url => data[:next_url]}, data[:next])
		assert_nil(data[:prev])
		assert_nil(data[:up])
		
		assert_equal('B', data[:next_title])
		assert_equal('x/b.html', data[:next_url])
		
		# x/b.html
		desc.publish_from = wp[:htsources_dir] + '/x/b.html'
		desc.publish_to = wp[:publish_dir] + '/x/b.html'
		data = NaviPage.new(desc)
		
		assert_equal({:title => data[:start_title], :url => data[:start_url]}, data[:start])
		assert_equal({:title => data[:chapter_title], :url => data[:chapter_url]}, data[:chapter])
		assert_nil( data[:section])
		
		assert_equal('B', data[:chapter_title])
		assert_equal('b.html', data[:chapter_url])
		
		assert_equal({:title => data[:next_title], :url => data[:next_url]}, data[:next])
		assert_equal({:title => data[:prev_title], :url => data[:prev_url]}, data[:prev])
		assert_equal({:title => data[:up_title], :url => data[:up_url]}, data[:up])
		
		assert_equal('C', data[:next_title])
		assert_equal('c.html', data[:next_url])
		
		# x/c.html
		desc.publish_from = wp[:htsources_dir] + '/x/c.html'
		desc.publish_to = wp[:publish_dir] + '/x/c.html'
		data = NaviPage.new(desc)
		
		assert_equal('SF.net', data[:next_title])
		assert_equal('http://sf.net', data[:next_url])
		
	end

	def test_expand
		wp = @workspace.web_project('navi_test_project')
		desc = PublishDescription.new('amrita', wp)
		
		desc.publish_from = wp[:htsources_dir] + '/a.html'
		desc.publish_to = wp[:publish_dir] + '/a.html'
		
		out = expand(desc)
		assert %r!<link rel="start" title="A" href="a.html">! === out
		assert %r!<link rel="next" title="B" href="x/b.html">! === out
		assert %r!<a href="x/b.html">B</a>! === out
		
		# puts out
	end

	def expand(desc)
		tmpl = Amrita::TemplateFile.new(desc.publish_from)
		tmpl.expand_attr = true
		out = ''
		tmpl.expand(out, NaviPage.new(desc))
		out
	end

	def put_page_data(data)
		data.sort { |a, b| a[0].to_s <=> b[0].to_s }.each { |k,v|
			p "#{k} => #{v}"
		}
	end

	def teardown
		FileUtils.rm_r(@proj_path)
	end

end
