/*
 * $Id: TopicTest.java,v 1.5 2004/06/07 06:46:51 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.tests.toc;

import java.io.IOException;

import junit.framework.TestCase;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.tests.WebpubTestPlugin;
import com.narucy.webpub.core.toc.*;

public class TopicTest extends TestCase {

	WebProject webProj;

	public TopicTest(String name) {
		super(name);
	}
	
	protected void setUp() throws Exception {
		webProj = WebpubTestPlugin.createTestProject("test_projects/SitemapTest");
	}
	
	public void testChangeLevelTest() throws IOException{
		Toc toc = webProj.getToc(webProj.getTocFiles()[0]);
		Topic tb = toc.findTopic("test2/b.html");
		Topic tc = toc.findTopic("test2/c.html");
		
		assertFalse(tb.levelUp());
		assertTrue(tc.levelUp());
		
		assertTrue(tb.levelDown());
		assertEquals("test1/a.html", tb.getPrevTopic(false).getHref());
		assertTrue(tb.levelDown());
		assertEquals("a.html", tb.getPrevTopic(false).getHref());
		assertTrue(tb.levelDown());
		assertEquals("home.html", tb.getPrevTopic(false).getHref());
		assertFalse(tb.levelDown());
		assertTrue(tc.levelDown());
		assertEquals("test2/b.html", tc.getPrevTopic(false).getHref());

		assertTrue(tb.levelUp());
		assertEquals("test4/a.html", tb.getPrevTopic(false).getHref());
		assertTrue(tb.levelUp());
		assertEquals("test4/c.html", tb.getPrevTopic(false).getHref() );
		assertTrue(tb.levelUp());
		assertNull( tb.getPrevTopic(false) );
		
		assertFalse(tb.levelUp());
	}

	public void testMoveTest(){
		Toc toc = webProj.getToc(webProj.getTocFiles()[0]);
		Topic tb = toc.findTopic("test2/b.html");
		Topic tc = toc.findTopic("test2/c.html");
		
		assertEquals(tc, tb.getNextTopic(true));
		assertEquals(tb, tc.getPrevTopic(true));
		assertEquals(tc, tb.getNextTopic(false));
		assertEquals(tb, tc.getPrevTopic(false));
		
		// test move in same level
		assertTrue( tb.moveDown() );
		assertEquals(1, tb.getParent().indexOf(tb) );
		assertEquals(0, tb.getParent().indexOf(tc) );
		assertTrue( tc.moveDown() );
		assertEquals(0, tb.getParent().indexOf(tb) );
		assertEquals(1, tb.getParent().indexOf(tc) );
		
		// test move up with children
		Topic t = toc.findTopic("test1/a.html");
		assertEquals(toc.findTopic("a.html"), t.getParent());
		
		assertEquals(toc.findTopic("test2/b.html"), t.getNextTopic(true));
		assertEquals(toc.findTopic("c.html"), t.getPrevTopic(true));
		assertEquals(toc.findTopic("test3/a.html"), t.getNextTopic(false));
		assertEquals(toc.findTopic("b.html"), t.getPrevTopic(false));

		assertTrue( t.moveUp() );
		assertEquals( null, t.getPrevTopic(false) );
		assertEquals( toc.findTopic("a.html"), t.getPrevTopic(true) );
		assertEquals( toc.findTopic("b.html"), t.getNextTopic(false) );
		assertEquals( toc.findTopic("test2/b.html"), t.getNextTopic(true) );
		
		assertEquals(0, t.getParent().indexOf(t) );
		assertFalse(t.moveUp());
	}
	
	protected void tearDown() throws Exception {
		WebpubTestPlugin.forceDelete(webProj.getProject());
	}

}
