/*
 * $Id: PublishResultReaderTest.java,v 1.7 2004/06/10 02:32:32 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.tests.publish;

import java.io.File;
import java.util.Arrays;

import junit.framework.TestCase;

import com.narucy.webpub.core.publish.PublishResultReader;
import com.narucy.webpub.core.tests.WebpubTestPlugin;

/**
 *
 */
public class PublishResultReaderTest extends TestCase {
	
	public PublishResultReaderTest(String name) {
		super(name);
	}
	
	public void testRun() throws Exception{
		File tmpFile = WebpubTestPlugin.createTempFile("PublishResultReaderTest.run");
		try{
			PublishResultReader reader = new PublishResultReader(
					getClass().getResource("publish_result").openStream(),
					"UTF-8",
					tmpFile);
			
			reader.start();
			while(!reader.isDone()){
				Thread.sleep(1000);
			}

			String[] okFiles = reader.getOKFiles();
			Arrays.sort(okFiles);
			for (int i = 0; i < okFiles.length; i++) {
				String f = okFiles[i];
				assertNotNull( reader.getPublishBy(f) );
				assertNull( reader.getRubyException(f) );
			}
			assertEquals(22, okFiles.length);
			
			String[] failedFiles = reader.getErrorFiles();
			Arrays.sort(failedFiles);
			for (int i = 0; i < failedFiles.length; i++) {
				String f = failedFiles[i];
				assertNotNull( reader.getPublishBy(f) );
				assertNotNull( reader.getRubyException(f) );
			}
			assertEquals(4, failedFiles.length);
		}finally{
			tmpFile.delete();
		}
	}
	
}
