/*
 * $Id: PublishErrorHandlerTest.java,v 1.4 2004/06/07 06:46:50 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.tests.publish;

import junit.framework.TestCase;

import org.eclipse.core.resources.*;

import com.narucy.webpub.core.tests.WebpubTestPlugin;

/**
 * 
 */
public class PublishErrorHandlerTest extends TestCase {
	
	IProject project;
	
	protected void setUp() throws Exception{
		project = WebpubTestPlugin.createTestProject("test_projects/ErrorHandling").getProject();
	}

	public void testCreateMarker() throws Exception {
		IMarker[] marker = project.getFile("ht_sources/amrita-syntax_error.html").findMarkers(null, false, IResource.DEPTH_ZERO);
		assertEquals(1, marker.length);
		assertEquals("syntax error", marker[0].getAttribute(IMarker.MESSAGE));
		
		marker = project.getFile("scripts/syntax_error.rb").findMarkers(null, false, IResource.DEPTH_ZERO);
		assertEquals(1, marker.length);
		assertEquals("syntax error", marker[0].getAttribute(IMarker.MESSAGE));
	}

	protected void tearDown() throws Exception {
		WebpubTestPlugin.forceDelete(project);
	}
	
}
