/*
 * $Id: PublishDescriptionTest.java,v 1.4 2004/06/01 13:31:40 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.tests.publish;

import junit.framework.TestCase;

import org.eclipse.core.runtime.Path;

import com.narucy.webpub.core.publish.PublishDescription;

/**
 * 
 */
public class PublishDescriptionTest extends TestCase {
	
	public PublishDescriptionTest(String name) {
		super(name);
	}
	
	public void testToString(){
		PublishDescription desc = new PublishDescription("foo");
		desc.setPublishTo(new Path("foo/bar/baz"));
		desc.setArgument("a", "001a");
		desc.setArgument("b", "002b");
		desc.setArgument("c", "003c");
		desc.setArgument("d", "004d");
		
		assertEquals(
			"by=foo,publish_to=/foo/bar/baz,arguments={a=001a, b=002b, c=003c, d=004d}",
			desc.toString());
	}

}