/*
 * $Id: PresetTest.java,v 1.4 2004/06/07 06:46:50 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.tests.presets;

import junit.framework.TestCase;

import org.eclipse.core.runtime.Path;

import com.narucy.webpub.core.preset.*;
import com.narucy.webpub.core.tests.WebpubTestPlugin;

public class PresetTest extends TestCase {

	public PresetTest(String name) {
		super(name);
	}
	
	public void testDistributeWithZip() throws Exception {
		Preset preset = PresetManager.createPreset(
				getClass().getResource("PresetTest-Shift_JIS.zip"),
				"name", "desc");
		
		assertEquals(ZippedPreset.class, preset.getClass());
		
		preset = PresetManager.createPreset(
				WebpubTestPlugin.getDefault().find(new Path("test_projects/PresetTestProject")),
				"name", "desc");
		
		assertEquals(FilePreset.class, preset.getClass());
	}
	
}
