/*
 * $Id: PresetManagerTest.java,v 1.10 2004/06/10 21:15:14 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.tests.presets;

import java.io.IOException;
import java.util.Properties;
import java.util.regex.Pattern;

import junit.framework.TestCase;

import org.eclipse.core.resources.*;

import com.narucy.webpub.core.*;
import com.narucy.webpub.core.preset.*;
import com.narucy.webpub.core.tests.WebpubTestPlugin;

public class PresetManagerTest extends TestCase {
	
	PresetManager manager = PresetManager.getInstance();

	public PresetManagerTest(String name){
		super(name);
	}
	
	public void testGetPreset() throws IOException{
		Preset[] presets = manager.getPresets();
		assertEquals(5, presets.length);
		/*
		for (int i = 0; i < presets.length; i++) {
			Preset preset = presets[i];
			p(preset.getName());
		}
		*/
		
		assertEquals("Company", presets[0].getName());
		assertTrue( Pattern.matches(".+/company.zip$", presets[0].getBaseDirectory().toString()) );
		assertTrue( Pattern.matches("^Company preset distributes ordinary.+", presets[0].getDescription()) );

		Properties prop = presets[0].getWebProjectProperty();
		assertEquals("ht_sources", prop.getProperty(WebProject.HTSOURCES_FOLDER));

		assertEquals("Empty", presets[2].getName());
		assertTrue(Pattern.matches(".+/empty.zip$", presets[2].getBaseDirectory().toString()));
		assertEquals(
				"Simple preset distributes only one html.",
				presets[2].getDescription());
	}

	public void testCompanyPreset() throws Exception{
		IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject("a");
		TextReader reader = null;
		try{
			Preset[] presets = manager.getPresets();
			WebProject wp = presets[0].distribute(proj, "x", "scripts", "z", null);
			
			IMarker[] markers = proj.findMarkers(null, false, IResource.DEPTH_INFINITE);
			for (int i = 0; i < markers.length; i++) {
				p( markers[i].getAttribute(IMarker.MESSAGE));
			}
			assertEquals(0, markers.length);
			assertTrue( proj.getFile("x/home.html").exists());
			assertTrue( proj.getFile("z/home.html").exists());
		}finally{
			if(reader != null){
				reader.close();
			}
			WebpubTestPlugin.forceDelete(proj);
		}
	}

	void p(Object o) {
		System.out.println(getClass() + ":" + o);
	}
	
}
