/*
 * $Id: FilePresetTest.java,v 1.7 2004/06/10 21:15:13 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.tests.presets;

import junit.framework.TestCase;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.preset.FilePreset;
import com.narucy.webpub.core.tests.WebpubTestPlugin;

/**
 *
 */
public class FilePresetTest extends TestCase {

	public FilePresetTest(String name) {
		super(name);
	}
	
	IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
	IProject project = null;
	
	public void testDistribute() throws Exception{
		try{
			project = root.getProject("webProject");
			FilePreset preset = new FilePreset(
					WebpubTestPlugin.getDefault().find(new Path("test_scripts/webpub/test_workspace/web_project")),
					"name",
					"description");
			
			WebProject wp = preset.distribute(project, "xxx", "yyy", "zzz", null);
			
			assertTrue(project.getFile("xxx/home.html").exists());
			assertTrue(project.getFile("xxx/home.png").exists());
			assertTrue(project.getFile("zzz/home.html").exists());
			assertTrue(project.getFile("zzz/home.gif").exists());
		}catch(CoreException e){
			e.printStackTrace();
			throw e;
		}
	}
	
	public void testGetDistributeFiles() throws Exception{
		project = root.getProject("webProject");
		FilePreset preset = new FilePreset(
				WebpubTestPlugin.getDefault().getBundle().getEntry("test_scripts/webpub/test_workspace/web_project"),
				"name",
				"description");
		
		assertEquals("name", preset.getName());
		assertEquals("description", preset.getDescription());
		
		WebProject wp = WebProject.distributeNewProject(project, "xxx", "yyy", "zzz", null);
	}
	
	public void testPresetTestProject() throws Exception {
		project = root.getProject("webProject");
		
		FilePreset preset = new FilePreset(
				WebpubTestPlugin.getDefault().getBundle().getEntry("test_projects/PresetTestProject"),
				"name",
				"description");
		
		WebProject wp = preset.distribute(project, "xxx", "yyy", "zzz", null);
		
		assertTrue(project.getFile("a/a_x").exists());
		
		assertTrue(project.getFolder("a/aa").exists());
		assertTrue(project.getFile("a/aa/aa_x").exists());
		assertTrue(project.getFile("a/aa/aa_y").exists());
		assertFalse(project.getFolder("a/aa/CVS").exists());
		
		assertTrue(project.getFile("b/b_x").exists());
	}
	
	protected void tearDown() throws Exception {
		if(project != null){
			WebpubTestPlugin.forceDelete(project);
			project = null;
		}
	}
}
