/*
 * $Id: WebpubTestPlugin.java,v 1.14 2004/06/07 06:46:49 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.tests;

import java.io.*;
import java.net.URL;
import java.util.regex.Pattern;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;
import org.eclipse.swt.widgets.Display;

import com.narucy.webpub.core.*;

/**
 * WebpubTestPlugin provides utilities methods.
 */
public class WebpubTestPlugin extends Plugin {

	final static String ID_PLUGIN = WebpubPlugin.ID_PLUGIN + ".tests";
	
	static WebpubTestPlugin plugin;
	
	public WebpubTestPlugin() {
		plugin = this;
	}
	
	public static WebpubTestPlugin getDefault(){
		return plugin;
	}

	public static void forceDelete(IProject proj) {
		while(proj.exists()){
			while(Display.getCurrent().readAndDispatch());
			System.gc();
			try {
				proj.refreshLocal(IResource.DEPTH_INFINITE, null);
				
				IProjectDescription projDesc = proj.getDescription();
				projDesc.setNatureIds(new String[]{});
				proj.setDescription(projDesc, null);
				proj.delete(true, null);
			}catch (CoreException e) {
				try {
					Thread.sleep(1000);
				} catch (InterruptedException ex) {
				}
			}
		}
	}

	public static WebProject createTestProject(String originalProjectPath) throws CoreException, IOException {
		URL url = Platform.asLocalURL( getDefault().getBundle().getEntry(originalProjectPath) );
		File f = new File(url.getFile());
		if(f.exists()){
			return createTestProject(f);
		}else{
			throw new IllegalArgumentException("not found:" + originalProjectPath);
		}
	}
	
	public static WebProject createTestProject(final File originalProjetDirectory) throws CoreException {
		final WebProject[] wp = {null};
		ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable() {
			public void run(IProgressMonitor monitor) throws CoreException {
				try{
					wp[0] = internalCreateTestProject(originalProjetDirectory);
				}catch(CoreException ex){
					ex.printStackTrace();
					throw ex;
				}
			}
		}, null);
		
		return wp[0];
	}
	
	public static void putsStatus(IStatus status){
		if(status.getException() != null){
			status.getException().printStackTrace();
		}
		IStatus[] ss = status.getChildren();
		for (int i = 0; i < ss.length; i++) {
			putsStatus(ss[i]);
		}
	}

	static WebProject internalCreateTestProject(File originalProjetDirectory) throws CoreException{
		IWorkspace workspace = ResourcesPlugin.getWorkspace();
		IWorkspaceRoot root = workspace.getRoot();
		
		String name = originalProjetDirectory.getName();
		
		IProject proj = root.getProject(name);
		IProjectDescription desc = workspace.newProjectDescription(name);
		proj.create(desc, null);
		proj.open(null);
		
		try {
			FileUtilities.copyWithDir(
				originalProjetDirectory,
				root.getLocation().toFile(),
				new Pattern[]{Pattern.compile("^CVS$")});
			
		} catch (IOException e) {
			throw new CoreException(new Status(
				IStatus.ERROR,
				WebpubTestPlugin.ID_PLUGIN,
				IStatus.OK,
				"occasion in doing copy test project files",
				e));
		}
		proj.close(null);
		proj.open(null);
		root.refreshLocal(IResource.DEPTH_INFINITE, null);
		
		WebProject wp = (WebProject)proj.getNature(WebProject.ID_NATURE);
		if(wp == null){
			throw new IllegalArgumentException("specified project is not web project");
		}
		wp.load();
		proj.build(IncrementalProjectBuilder.FULL_BUILD, null);
		
		return wp;
	}
	
	public static File createTempFile(String suffix) throws IOException{
		return File.createTempFile("com.narucy.webpub.core.tests", suffix);
	}

}
