/*
 * $Id: WebProjectTest.java,v 1.9 2004/06/07 06:46:49 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.tests;

import java.util.Arrays;

import junit.framework.TestCase;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.NullProgressMonitor;

import com.narucy.webpub.core.WebProject;

public class WebProjectTest extends TestCase {

	public WebProjectTest(String arg0) {
		super(arg0);
	}

	public void testToArray() throws Exception {
		String a = "";
		assertEquals(0, WebProject.toArray(a).length);
		String b = "   ";
		assertEquals(0, WebProject.toArray(b).length);
		String c = "\t \t";
		assertEquals(0, WebProject.toArray(c).length);
		String d = "\tx \t y \t\t\tz";
		
		String[] vals = WebProject.toArray(d);
		assertTrue(Arrays.equals(new String[]{"x", "y", "z"}, vals) );
	}
	
	public void testStoreNewProject() throws Exception {
		IWorkspace workspace = ResourcesPlugin.getWorkspace();
		IWorkspaceRoot root = workspace.getRoot();
		root.refreshLocal(IResource.DEPTH_INFINITE, new NullProgressMonitor() );
		
		IProject proj = root.getProject("aproject");
		try{
			// setup - prepare workspace			
			assertFalse(proj.exists());
			
			// create project
			NullProgressMonitor monitor = new NullProgressMonitor();
			WebProject.distributeNewProject(proj, "a", "b", "c", null);
		
			WebProject desc = (WebProject)proj.getNature(WebProject.ID_NATURE);
			proj.refreshLocal(IResource.DEPTH_INFINITE, monitor);
		
			// checks configuration file created
			IFile f = proj.getFile("/.webproject");
			assertTrue( f.exists() );

			// checks folder names
			assertEquals( "a", desc.getString( WebProject.HTSOURCES_FOLDER));
			assertEquals( "b", desc.getString( WebProject.SCRIPTS_FOLDER));
			assertEquals( "c", desc.getString( WebProject.PUBLISH_FOLDER));

			// checks folder created
			assertTrue( proj.exists() );
			assertTrue( proj.getFolder("a").exists() );
			assertTrue( proj.getFolder("b").exists() );
			assertTrue( proj.getFolder("c").exists() );

			// create web project description form before created project.
			proj.refreshLocal(IProject.DEPTH_ONE, monitor);
			
		}finally{
			WebpubTestPlugin.forceDelete(proj);
		}
	}

	static WebProject createWebProject(IProject proj, String htSource, String scripts, String publish, String[] exts){
		WebProject webProj = new WebProject();
		webProj.setProject(proj);
		webProj.setValue( WebProject.HTSOURCES_FOLDER, htSource);
		webProj.setValue( WebProject.SCRIPTS_FOLDER, scripts);
		webProj.setValue( WebProject.PUBLISH_FOLDER, publish);
		webProj.setValue( WebProject.HT_EXTENSIONS, exts);
		return webProj;
	}

	public void testEquals() {
		IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
		
		IProject proja = root.getProject("a");
		IProject projb = root.getProject("b");
		
		WebProject pa = createWebProject(proja, "a", "b", "c", new String[]{"html", "xhtml"});
		assertTrue(pa.equals(pa));
		assertFalse( pa.equals(null));
		
		WebProject pb = createWebProject(projb, "a", "b", "c", new String[]{"html", "xhtml"});
		assertFalse( pa.equals(pb));

		WebProject pc = createWebProject(proja, "a", "b", "cc", new String[]{"html", "xhtml"});
		assertFalse( pa.equals(pc));
		
		WebProject pd = createWebProject(proja, "a", "b", "c", new String[]{"html", "phpl"});
		assertFalse(pa.equals(pd));
	}
	
	public void testCreateTestProject() throws Exception {
		WebProject wp = WebpubTestPlugin.createTestProject("test_scripts/webpub/test_workspace/web_project");
		IProject proj = wp.getProject();
		try{
			assertTrue(wp.getProject().hasNature(WebProject.ID_NATURE));
			assertSame(wp, wp.getProject().getNature(WebProject.ID_NATURE));
			
			assertEquals("web_project", wp.getProject().getName());
			
			IFolder folder = proj.getFolder("public_html");
			assertTrue(folder.exists());
			
			assertTrue(folder.getFile("home.gif").exists());
			assertTrue(folder.getFile("imgs/a.png").exists());
			assertTrue(folder.getFile("folder/subfolder/subsubfolder/1-1-1-1.html").exists());
		}finally{
			WebpubTestPlugin.forceDelete(proj);
		}
	}

}
