/*
 * $Id: HTMLUtilitiesTest.java,v 1.1 2004/03/26 04:49:59 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.tests;

import junit.framework.TestCase;

import com.narucy.webpub.core.HTMLUtilities;

/**
 * 
 */
public class HTMLUtilitiesTest extends TestCase {

	public HTMLUtilitiesTest(String arg0) {
		super(arg0);
	}

	public void testEscape() {
		assertEquals("&lt;&gt;&amp;&quot;", HTMLUtilities.escape("<>&\""));
		assertEquals("&quot;&amp;&gt;&lt;", HTMLUtilities.escape("\"&><"));
	}

	public void testUnescape() {
		assertEquals("<>&\"", HTMLUtilities.unescape("&lt;&gt;&amp;&quot;"));
		assertEquals("\"&><", HTMLUtilities.unescape("&quot;&amp;&gt;&lt;"));
	}

}
