/*
 * $Id: PublishDescriptorDefinitionPage.java,v 1.1 2004/04/11 08:23:38 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.properties;

import java.io.IOException;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

import com.narucy.webpub.core.*;
import com.narucy.webpub.core.publish.*;
import com.narucy.webpub.ui.WebpubUIPlugin;


/**
 * PublishDescriptorDefinitionPage provides publish description editing ui.
 * @see PropertyPage
 */
public class PublishDescriptorDefinitionPage extends PropertyPage implements IWorkbenchPropertyPage {

	IFile editTarget;

	Button
		noPublishButton,
		useParentButton,
		openParentButton,
		useCurrentButton;
	
	PublishDescriptorDifinitionBlock block;

	SelectionListener radioSelectionListener = new SelectionListener() {
		public void widgetSelected(SelectionEvent e) {
			refreshControls();
		}

		public void widgetDefaultSelected(SelectionEvent e) {}
	};

	public PublishDescriptorDefinitionPage() {
	}
	
	protected Control createContents(Composite parent)  {
		final IFolder folder = (IFolder)getElement().getAdapter(IFolder.class);
		editTarget = folder.getFile(".publish");
		
		boolean fileExist = editTarget.exists();
		
		// create controls
		Composite base = new Composite(parent, SWT.NONE);
		base.setLayout(new GridLayout(1, false));
		
		noPublishButton = createButton(base, "&No Publish");
		
		useParentButton = createButton(base, "Use &Parent Setting");
		openParentButton = new Button(base, SWT.PUSH);
		openParentButton.setText("&Open Parent Description");
		
		// init button state for publish description state.
		try{
			PublishDescriptionFactory descFactory =
				((WebProject)folder.getProject().getNature(WebProject.ID_NATURE)).getPublishDescriptionFactory();
			
			if( descFactory.create(folder) == null){
				noPublishButton.setSelection(!fileExist);
				useParentButton.setEnabled(false);
				openParentButton.setEnabled(false);
			}else{
				useParentButton.setSelection(!fileExist);
				noPublishButton.setEnabled(false);
	
				final IFile[] parentPublishPropFiles = descFactory.findPublishPropertyFiles(folder);
				if(parentPublishPropFiles.length > 0){
					openParentButton.addSelectionListener(new SelectionAdapter() {
						public void widgetSelected(SelectionEvent e) {
							openPublishDescriptorDefinicationDialog(parentPublishPropFiles[0], getShell());
						}
					});
				}else{
					openParentButton.setEnabled(false);
				}
			}
		} catch(CoreException e){
			openParentButton.setEnabled(false);
		} catch (IllegalConfigurationException e) {
			WebpubUIPlugin.handleException(e);
		} catch (IOException e) {
			WebpubUIPlugin.handleException(e);
		}
		
		// define in current folder settings control
		
		useCurrentButton = createButton(base, "Use &Current Folder Settings");
		useCurrentButton.setSelection(fileExist);
		block = new PublishDescriptorDifinitionBlock(base, editTarget, new IStatusChangeListener() {
			public void statusChanged(IStatus status) {
				setErrorMessage( status.getSeverity() == IStatus.ERROR ? status.getMessage() : null);
			}
		});
		block.getControl().setLayoutData( new GridData(GridData.FILL_BOTH));
		
		new Text(base, SWT.READ_ONLY | SWT.MULTI | SWT.WRAP)
			.setText("Note: If you selection parent setting, remove a publish description file of this folder.");

		refreshControls();
		return base;
	}
	
	void initButtonStatue(){
		
	}

	Button createButton(Composite base, String name){
		Button button = new Button(base, SWT.RADIO);
		button.addSelectionListener(radioSelectionListener);
		button.setText(name);
		return button;
	}
	
	void refreshControls(){
		block.setEnabled( useCurrentButton.getSelection() );
	}
	
	/**
	 * Open a publish descriptor definication dialog.
	 * Specifiy publish description file is modifing target for user.
	 */
	public static void openPublishDescriptorDefinicationDialog(final IFile pubDescFile, Shell parentShell){
		Dialog dialog = new Dialog(parentShell) {
			
			PublishDescriptorDifinitionBlock block;
			
			protected Point getInitialSize(){
				Point p = super.getInitialSize();
				return new Point( (int)(p.x * 1.25), (int)(p.y * 1.5) );
			}

			protected Control createDialogArea(Composite parent) {
				Composite base = (Composite)super.createDialogArea(parent);
				
				Shell newShell = base.getShell();
				newShell.setText("Publish Descriptor Definition - " + pubDescFile.getFullPath());
				
				base.setLayout(new FillLayout());
				block = new PublishDescriptorDifinitionBlock(base, pubDescFile, null);
				
				return base;
			}
			
			protected void okPressed() {
				try {
					block.store();
				} catch (CoreException e) {
					WebpubUIPlugin.handleException(e);
				}
				super.okPressed();
			}
			
			protected int getShellStyle(){
				return super.getShellStyle() | SWT.MAX | SWT.RESIZE;
			}
		};
		
		dialog.open();
	}

	/**
	 * Store the edited document instance.
	 */
	public boolean performOk() {
		super.performOk();
		try{
			if( useCurrentButton.getSelection() ){
				return block.store();
			}else{
				IFile target = block.getEditTarget();
				if( target != null && target.exists() ){
					target.delete(true, null);
				}
			}
		}catch(CoreException e){
			WebpubUIPlugin.handleException(e);
		}
		return true;
	}

}
