/*
 * $Id: TocTextEditor.java,v 1.4 2004/04/16 01:45:01 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.editors.toc;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;
import org.eclipse.jface.text.*;
import org.eclipse.ui.*;
import org.eclipse.ui.editors.text.TextEditor;
import org.xml.sax.SAXException;

import com.narucy.webpub.core.toc.*;
import com.narucy.webpub.ui.WebpubUIPlugin;

/**
 * 
 */
class TocTextEditor extends TextEditor {

	final TocMultiPageEditor parentEditor;
	IDocument doc;

	TocListener tocListener = new TocListener() {
		public void topicChanged(TocEvent[] events) {
			Toc toc = parentEditor.getToc();
			try {
				doc.set( TocStore.expandElement(toc) );
			} catch (CoreException e) {
				WebpubUIPlugin.handleException(e);
			}
		}
	};
	
	IDocumentListener docListener = new IDocumentListener() {
		public void documentAboutToBeChanged(DocumentEvent event) {}

		public void documentChanged(DocumentEvent event) {
			Toc toc = parentEditor.getToc();
			toc.removeTocListener(tocListener);
			try {
				revalidate();
			} catch (SAXException e) {
				Topic[] ts = toc.getSubtopics();
				for (int i = 0; i < ts.length; i++) {
					toc.removeTopic(ts[i]);
				}
				toc.fireChanged();
			} catch (CoreException e) {
				WebpubUIPlugin.handleException(e);
			}finally{
				toc.addTocListener(tocListener);
			}
		}
	};
	
	public TocTextEditor(TocMultiPageEditor parentEditor) {
		this.parentEditor = parentEditor;
	}
	
	public void init(IEditorSite site, IEditorInput input) throws PartInitException {
		super.init(site, input);
		parentEditor.getToc().addTocListener(tocListener);
		
		doc = getDocumentProvider().getDocument(input);
		doc.addDocumentListener(docListener);
	}
	
	void revalidate() throws SAXException, CoreException {
		IDocument doc = getDocumentProvider().getDocument(getEditorInput());
		
		Toc toc = parentEditor.getToc();
		toc.applyToc( TocFactory.createToc(doc.get()) );
		toc.fireChanged();	
	}
	
	IMarker createMarker(String type) throws CoreException{
		IMarker m = ((IFileEditorInput)getEditorInput()).getFile().createMarker(type);
		m.setAttribute(TocFactory.ID_MARKER_TOC_PROBLEM, true);
		return m;
	}
	
	void deleteMarker() throws CoreException{
		IMarker[] markers = ((IFileEditorInput)getEditorInput()).getFile().findMarkers(null, true, IResource.DEPTH_ZERO);
		for (int i = 0; i < markers.length; i++) {
			IMarker m = markers[i];
			if( Boolean.TRUE.equals(m.getAttribute(TocFactory.ID_MARKER_TOC_PROBLEM)) ){
				m.delete();
			}
		}
	}

	public void doSave(IProgressMonitor monitor) {
		try{
			deleteMarker();
			try {
				revalidate();
			} catch (SAXException e) {
				IMarker m = createMarker(IMarker.PROBLEM);
				m.setAttribute(IMarker.MESSAGE, e.getLocalizedMessage());
			}
			super.doSave(monitor);
		}catch(CoreException e){
			WebpubUIPlugin.handleException(e);
		}
	}

	public void dispose() {
		parentEditor.getToc().removeTocListener(tocListener);
		doc.removeDocumentListener(docListener);
		super.dispose();
	}


}
